/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionList;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Exists/Is Set")
@Description(value={"Checks whether a given expression or variable is set."})
@Examples(value={"{teams::%player's uuid%::preferred-team} is not set", "on damage:", "\tprojectile exists", "\tbroadcast \"%attacker% used a %projectile% to attack %victim%!\""})
@Since(value="1.2")
public class CondIsSet
extends Condition {
    private Expression<?> expr;

    static {
        Skript.registerCondition(CondIsSet.class, "%~objects% (exist[s]|(is|are) set)", "%~objects% (do[es](n't| not) exist|(is|are)(n't| not) set)");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.expr = exprs[0];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    private boolean check(Expression<?> expr, Event e) {
        if (expr instanceof ExpressionList) {
            Expression<T>[] expressionArray = ((ExpressionList)expr).getExpressions();
            int n = expressionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Expression ex = expressionArray[n2];
                assert (ex != null);
                boolean b = this.check(ex, e);
                if (expr.getAnd() ^ b) {
                    return !expr.getAnd();
                }
                ++n2;
            }
            return expr.getAnd();
        }
        assert (expr.getAnd());
        ?[] all = expr.getAll(e);
        return this.isNegated() ^ all.length != 0;
    }

    @Override
    public boolean check(Event e) {
        return this.check(this.expr, e);
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return String.valueOf(this.expr.toString(e, debug)) + " " + (this.isNegated() ? "isn't" : "is") + " set";
    }
}

