/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Is in World")
@Description(value={"Checks whether an entity is in a specific world."})
@Examples(value={"player is in \"world\"", "argument isn't in world \"world_nether\"", "the player is in the world of the victim"})
@Since(value="1.4")
public class CondIsInWorld
extends Condition {
    private Expression<Entity> entities;
    Expression<World> worlds;

    static {
        Skript.registerCondition(CondIsInWorld.class, "%entities% (is|are) in [[the] world[s]] %worlds%", "%entities% (is not|isn't|are not|aren't) in [[the] world[s]] %worlds%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entities = exprs[0];
        this.worlds = exprs[1];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    @Override
    public boolean check(final Event e) {
        return this.entities.check(e, new Checker<Entity>(){

            @Override
            public boolean check(final Entity en) {
                return CondIsInWorld.this.worlds.check(e, new Checker<World>(){

                    @Override
                    public boolean check(World w) {
                        return en.getWorld() == w;
                    }
                }, CondIsInWorld.this.isNegated());
            }
        });
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return String.valueOf(this.entities.toString(e, debug)) + " " + (this.entities.isSingle() ? "is" : "are") + " " + (this.isNegated() ? "not " : "") + "in the world " + this.worlds.toString(e, debug);
    }
}

