/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Can Fly")
@Description(value={"Whether a player is allowed to fly."})
@Examples(value={"player can fly"})
@Since(value="INSERT VERSION")
public class CondCanFly
extends Condition {
    private Expression<Player> players;

    static {
        Skript.registerCondition(CondCanFly.class, "%players% can fly", "%players% (can't|can[ ]not) fly");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.players = exprs[0];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    @Override
    public boolean check(Event e) {
        return this.players.check(e, Player::getAllowFlight, this.isNegated());
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return String.valueOf(this.players.toString(e, debug)) + (this.isNegated() ? " can " : " cannot ") + "fly";
    }
}

