/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes;

import ch.njol.skript.classes.Arithmetic;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.SerializableChanger;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.lang.Debuggable;
import ch.njol.skript.lang.DefaultExpression;
import ch.njol.skript.localization.Noun;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

@SuppressFBWarnings(value={"DM_STRING_VOID_CTOR"})
public class ClassInfo<T>
implements Debuggable {
    private final Class<T> c;
    private final String codeName;
    private final Noun name;
    @Nullable
    private DefaultExpression<T> defaultExpression = null;
    @Nullable
    private Parser<? extends T> parser = null;
    @Nullable
    private Pattern[] userInputPatterns = null;
    @Nullable
    private Changer<? super T> changer = null;
    @Nullable
    private Serializer<? super T> serializer = null;
    @Nullable
    private Class<?> serializeAs = null;
    @Nullable
    private Arithmetic<? super T, ?> math = null;
    @Nullable
    private Class<?> mathRelativeType = null;
    @Nullable
    private String docName = null;
    @Nullable
    private String[] description = null;
    @Nullable
    private String[] usage = null;
    @Nullable
    private String[] examples = null;
    @Nullable
    private String since = null;
    public static final String NO_DOC = new String();
    @Nullable
    private Set<String> before;
    private final Set<String> after = new HashSet<String>();

    public ClassInfo(Class<T> c, String codeName) {
        this.c = c;
        if (!ClassInfo.isVaildCodeName(codeName)) {
            throw new IllegalArgumentException("Code names for classes must be lowercase and only consist of latin letters and arabic numbers");
        }
        this.codeName = codeName;
        this.name = new Noun("types." + codeName);
    }

    public static final boolean isVaildCodeName(String name) {
        return name.matches("[a-z0-9]+");
    }

    public ClassInfo<T> parser(Parser<? extends T> parser) {
        assert (this.parser == null);
        this.parser = parser;
        return this;
    }

    public ClassInfo<T> user(String ... userInputPatterns) throws PatternSyntaxException {
        assert (this.userInputPatterns == null);
        this.userInputPatterns = new Pattern[userInputPatterns.length];
        int i = 0;
        while (i < userInputPatterns.length) {
            assert (this.userInputPatterns != null);
            this.userInputPatterns[i] = Pattern.compile(userInputPatterns[i]);
            ++i;
        }
        return this;
    }

    public ClassInfo<T> defaultExpression(DefaultExpression<T> defaultExpression) {
        assert (this.defaultExpression == null);
        if (!defaultExpression.isDefault()) {
            throw new IllegalArgumentException("defaultExpression.isDefault() must return true for the default expression of a class");
        }
        this.defaultExpression = defaultExpression;
        return this;
    }

    public ClassInfo<T> serializer(Serializer<? super T> serializer) {
        assert (this.serializer == null);
        if (this.serializeAs != null) {
            throw new IllegalStateException("Can't set a serializer if this class is set to be serialized as another one");
        }
        this.serializer = serializer;
        serializer.register(this);
        return this;
    }

    public ClassInfo<T> serializeAs(Class<?> serializeAs) {
        assert (this.serializeAs == null);
        if (this.serializer != null) {
            throw new IllegalStateException("Can't set this class to be serialized as another one if a serializer is already set");
        }
        this.serializeAs = serializeAs;
        return this;
    }

    @Deprecated
    public ClassInfo<T> changer(SerializableChanger<? super T> changer) {
        return this.changer((Changer<? super T>)changer);
    }

    public ClassInfo<T> changer(Changer<? super T> changer) {
        assert (this.changer == null);
        this.changer = changer;
        return this;
    }

    public <R> ClassInfo<T> math(Class<R> relativeType, Arithmetic<? super T, R> math) {
        assert (this.math == null);
        this.math = math;
        this.mathRelativeType = relativeType;
        return this;
    }

    public ClassInfo<T> name(String name) {
        assert (this.docName == null);
        this.docName = name;
        return this;
    }

    public ClassInfo<T> description(String ... description) {
        assert (this.description == null);
        this.description = description;
        return this;
    }

    public ClassInfo<T> usage(String ... usage) {
        assert (this.usage == null);
        this.usage = usage;
        return this;
    }

    public ClassInfo<T> examples(String ... examples) {
        assert (this.examples == null);
        this.examples = examples;
        return this;
    }

    public ClassInfo<T> since(String since) {
        assert (this.since == null);
        this.since = since;
        return this;
    }

    public Class<T> getC() {
        return this.c;
    }

    public Noun getName() {
        return this.name;
    }

    public String getCodeName() {
        return this.codeName;
    }

    @Nullable
    public DefaultExpression<T> getDefaultExpression() {
        return this.defaultExpression;
    }

    @Nullable
    public Parser<? extends T> getParser() {
        return this.parser;
    }

    @Nullable
    public Pattern[] getUserInputPatterns() {
        return this.userInputPatterns;
    }

    @Nullable
    public Changer<? super T> getChanger() {
        return this.changer;
    }

    @Nullable
    public Serializer<? super T> getSerializer() {
        return this.serializer;
    }

    @Nullable
    public Class<?> getSerializeAs() {
        return this.serializeAs;
    }

    @Nullable
    public Arithmetic<? super T, ?> getMath() {
        return this.math;
    }

    @Nullable
    public <R> Arithmetic<T, R> getRelativeMath() {
        return this.math;
    }

    @Nullable
    public Class<?> getMathRelativeType() {
        return this.mathRelativeType;
    }

    @Nullable
    public String[] getDescription() {
        return this.description;
    }

    @Nullable
    public String[] getUsage() {
        return this.usage;
    }

    @Nullable
    public String[] getExamples() {
        return this.examples;
    }

    @Nullable
    public String getSince() {
        return this.since;
    }

    @Nullable
    public String getDocName() {
        return this.docName;
    }

    public ClassInfo<T> before(String ... before) {
        assert (this.before == null);
        this.before = new HashSet<String>(Arrays.asList(before));
        return this;
    }

    public ClassInfo<T> after(String ... after) {
        this.after.addAll(Arrays.asList(after));
        return this;
    }

    @Nullable
    public Set<String> before() {
        return this.before;
    }

    public Set<String> after() {
        return this.after;
    }

    @Override
    @NonNull
    public String toString() {
        return this.getName().getSingular();
    }

    public String toString(int flags) {
        return this.getName().toString(flags);
    }

    @Override
    @NonNull
    public String toString(@Nullable Event e, boolean debug) {
        if (debug) {
            return String.valueOf(this.codeName) + " (" + this.c.getCanonicalName() + ")";
        }
        return this.getName().getSingular();
    }
}

