/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.bukkitutil.block;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.Aliases;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.bukkitutil.block.BlockCompat;
import ch.njol.skript.bukkitutil.block.BlockSetter;
import ch.njol.skript.bukkitutil.block.BlockValues;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.type.Bed;
import org.bukkit.entity.FallingBlock;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

public class NewBlockCompat
implements BlockCompat {
    private NewBlockSetter setter = new NewBlockSetter();

    @Override
    @Nullable
    public BlockValues getBlockValues(BlockState block) {
        if (BlockData.class.isAssignableFrom(block.getType().data)) {
            return new NewBlockValues(block.getType(), block.getBlockData());
        }
        return null;
    }

    @Override
    @Nullable
    public BlockValues getBlockValues(ItemStack stack) {
        Material type = stack.getType();
        if (BlockData.class.isAssignableFrom(type.data)) {
            return new NewBlockValues(type, Bukkit.createBlockData((Material)type));
        }
        return null;
    }

    @Override
    public BlockSetter getSetter() {
        return this.setter;
    }

    @Override
    public BlockState fallingBlockToState(FallingBlock entity) {
        BlockState state = entity.getWorld().getBlockAt(0, 0, 0).getState();
        state.setBlockData(entity.getBlockData());
        return state;
    }

    @Override
    @Nullable
    public BlockValues createBlockValues(Material type, Map<String, String> states) {
        if (states.isEmpty()) {
            return null;
        }
        StringBuilder combined = new StringBuilder("[");
        boolean first = true;
        for (Map.Entry<String, String> entry : states.entrySet()) {
            if (first) {
                first = false;
            } else {
                combined.append(',');
            }
            combined.append(entry.getKey()).append('=').append(entry.getValue());
        }
        combined.append(']');
        try {
            BlockData data = Bukkit.createBlockData((Material)type, (String)combined.toString());
            assert (data != null);
            return new NewBlockValues(type, data);
        }
        catch (IllegalArgumentException e) {
            Skript.error("Parsing block state " + combined + " failed!");
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean isEmpty(Material type) {
        return type == Material.AIR || type == Material.CAVE_AIR || type == Material.VOID_AIR;
    }

    @Override
    public boolean isLiquid(Material type) {
        return type == Material.WATER || type == Material.LAVA;
    }

    private static class NewBlockSetter
    implements BlockSetter {
        private ItemType floorTorch;
        private ItemType wallTorch;
        private ItemType specialTorchSides;
        private ItemType specialTorchFloors;
        private boolean typesLoaded = false;
        private BlockFace[] faces = BlockFace.values();

        @Override
        public void setBlock(Block block, Material type, @Nullable BlockValues values, int flags) {
            Bed data;
            if (!this.typesLoaded) {
                this.loadTypes();
            }
            boolean rotate = (flags | 1) != 0;
            boolean rotateForce = (flags | 2) != 0;
            boolean rotateFixType = (flags | 4) != 0;
            boolean multipart = (flags | 8) != 0;
            boolean applyPhysics = (flags | 0x10) != 0;
            NewBlockValues ourValues = null;
            if (values != null) {
                ourValues = (NewBlockValues)values;
            }
            Class dataType = type.data;
            boolean placed = false;
            if (rotate) {
                Block relative;
                BlockFace face;
                if (rotateFixType || this.floorTorch.isOfType(type)) {
                    Block under = block.getRelative(0, -1, 0);
                    boolean canPlace = true;
                    if (!under.getType().isOccluding()) {
                        canPlace = this.specialTorchFloors.isOfType(under);
                    }
                    if (!canPlace && (face = this.findWallTorchSide(block)) != null) {
                        block.setType(this.wallTorch.getMaterial());
                        Directional data2 = (Directional)block.getBlockData();
                        data2.setFacing(face);
                        block.setBlockData((BlockData)data2, applyPhysics);
                        placed = true;
                    }
                } else if (this.wallTorch.isOfType(type) && (!(relative = block.getRelative((data = ourValues != null ? (Directional)ourValues.data : (Directional)Bukkit.createBlockData((Material)type)).getFacing())).getType().isOccluding() && !this.specialTorchSides.isOfType(relative) || rotateForce) && (face = this.findWallTorchSide(block)) != null) {
                    block.setType(type);
                    data.setFacing(face);
                    block.setBlockData((BlockData)data, applyPhysics);
                    placed = true;
                }
            }
            if (multipart) {
                if (Bed.class.isAssignableFrom(dataType)) {
                    BlockFace facing;
                    data = ourValues != null ? (Bed)ourValues.data : (Bed)Bukkit.createBlockData((Material)type);
                    block.setType(type, false);
                    block.setBlockData((BlockData)data, applyPhysics);
                    BlockFace otherFacing = facing = data.getFacing();
                    Bed.Part otherPart = Bed.Part.HEAD;
                    if (data.getPart().equals((Object)Bed.Part.HEAD)) {
                        facing = facing.getOppositeFace();
                        otherPart = Bed.Part.FOOT;
                    }
                    Block other = block.getRelative(facing);
                    other.setType(type, false);
                    data.setPart(otherPart);
                    data.setFacing(otherFacing);
                    other.setBlockData((BlockData)data, applyPhysics);
                    placed = true;
                }
                if (Bisected.class.isAssignableFrom(dataType)) {
                    data = ourValues != null ? (Bisected)ourValues.data : (Bisected)Bukkit.createBlockData((Material)type);
                    block.setType(type, false);
                    block.setBlockData((BlockData)data, applyPhysics);
                    BlockFace facing = BlockFace.DOWN;
                    Bisected.Half otherHalf = Bisected.Half.BOTTOM;
                    if (data.getHalf().equals((Object)Bisected.Half.BOTTOM)) {
                        facing = BlockFace.UP;
                        otherHalf = Bisected.Half.TOP;
                    }
                    Block other = block.getRelative(facing);
                    other.setType(type, false);
                    data.setHalf(otherHalf);
                    other.setBlockData((BlockData)data, applyPhysics);
                    placed = true;
                }
            }
            if (!placed) {
                block.setType(type);
                if (ourValues != null) {
                    block.setBlockData(ourValues.data, applyPhysics);
                }
            }
        }

        private void loadTypes() {
            this.floorTorch = Aliases.javaItemType("floor torch");
            this.wallTorch = Aliases.javaItemType("wall torch");
            this.specialTorchSides = Aliases.javaItemType("special torch sides");
            this.specialTorchFloors = Aliases.javaItemType("special torch floors");
            this.typesLoaded = true;
        }

        @Nullable
        private BlockFace findWallTorchSide(Block block) {
            BlockFace[] blockFaceArray = this.faces;
            int n = this.faces.length;
            int n2 = 0;
            while (n2 < n) {
                BlockFace face = blockFaceArray[n2];
                assert (face != null);
                Block relative = block.getRelative(face);
                if (relative.getType().isOccluding() || this.specialTorchSides.isOfType(relative)) {
                    return face.getOppositeFace();
                }
                ++n2;
            }
            return null;
        }
    }

    private static class NewBlockValues
    extends BlockValues {
        Material type;
        BlockData data;

        public NewBlockValues(Material type, BlockData data) {
            this.type = type;
            this.data = data;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (!(other instanceof NewBlockValues)) {
                return false;
            }
            NewBlockValues n = (NewBlockValues)other;
            return this.data.matches(n.data) && this.type.equals((Object)n.type);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = prime * result + (this.data == null ? 0 : this.data.hashCode());
            result = prime * result + this.type.hashCode();
            return result;
        }
    }
}

