/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.bukkitutil.block;

import ch.njol.skript.Skript;
import ch.njol.skript.bukkitutil.block.BlockCompat;
import ch.njol.skript.bukkitutil.block.BlockSetter;
import ch.njol.skript.bukkitutil.block.BlockValues;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.FallingBlock;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

public class MagicBlockCompat
implements BlockCompat {
    private static final MethodHandle setRawDataMethod;
    private static final MethodHandle getBlockDataMethod;
    static final MethodHandle setDataMethod;

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            MethodHandle mh = lookup.findVirtual(BlockState.class, "setRawData", MethodType.methodType(Void.TYPE, Byte.TYPE));
            assert (mh != null);
            setRawDataMethod = mh;
            mh = lookup.findVirtual(FallingBlock.class, "getBlockData", MethodType.methodType(Byte.TYPE));
            assert (mh != null);
            getBlockDataMethod = mh;
            mh = lookup.findVirtual(Block.class, "setData", MethodType.methodType(Void.TYPE, Byte.TYPE));
            assert (mh != null);
            setDataMethod = mh;
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new Error(e);
        }
    }

    @Override
    public BlockValues getBlockValues(BlockState block) {
        return new MagicBlockValues(block);
    }

    @Override
    public BlockState fallingBlockToState(FallingBlock entity) {
        BlockState state = entity.getWorld().getBlockAt(0, 0, 0).getState();
        state.setType(entity.getMaterial());
        try {
            setRawDataMethod.invokeExact(state, getBlockDataMethod.invokeExact(entity));
        }
        catch (Throwable e) {
            Skript.exception(e, new String[0]);
        }
        return state;
    }

    private Map<String, String> parseState(String state) {
        HashMap<String, String> parsed = new HashMap<String, String>();
        int pos = 0;
        while (pos != -1) {
            String pair;
            int comma = state.indexOf(44, pos);
            if (comma == -1) {
                pair = state.substring(pos);
                pos = -1;
            } else {
                pair = state.substring(pos, comma);
                pos = comma + 1;
            }
            String[] parts = pair.split("=");
            parsed.put(parts[0], parts[1]);
        }
        return parsed;
    }

    @Override
    @Nullable
    public BlockValues createBlockValues(Material type, Map<String, String> states) {
        boolean data = false;
        return new MagicBlockValues(type, (byte)(data ? 1 : 0));
    }

    @Override
    public boolean isEmpty(Material type) {
        return type == Material.AIR;
    }

    @Override
    public boolean isLiquid(Material type) {
        return type == Material.WATER || type == Material.LAVA;
    }

    @Override
    public BlockValues getBlockValues(ItemStack stack) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public BlockSetter getSetter() {
        throw new UnsupportedOperationException("not yet implemented");
    }

    private class MagicBlockValues
    extends BlockValues {
        private Material id;
        private byte data;

        public MagicBlockValues(BlockState block) {
            this.id = block.getType();
            this.data = block.getRawData();
        }

        public MagicBlockValues(ItemStack stack) {
            this.id = stack.getType();
            this.data = stack.getData().getData();
        }

        public MagicBlockValues(Material id, byte data) {
            this.id = id;
            this.data = data;
        }

        public void setBlock(Block block, boolean applyPhysics) {
            block.setType(this.id);
            try {
                setDataMethod.invokeExact(block, this.data);
            }
            catch (Throwable e) {
                Skript.exception(e, new String[0]);
            }
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (!(other instanceof MagicBlockValues)) {
                return false;
            }
            MagicBlockValues magic = (MagicBlockValues)other;
            return this.id == magic.id && this.data == magic.data;
        }

        @Override
        public int hashCode() {
            return this.id.ordinal() << 8 | this.data & 0xFF;
        }
    }
}

