/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.aliases;

import org.bukkit.Material;

public class MaterialRegistry {
    private Material[] materials;
    private int[] ids;

    public MaterialRegistry(Material[] materials) {
        this.materials = materials;
        this.ids = new int[materials.length];
        int i = 0;
        while (i < materials.length) {
            Material m = materials[i];
            this.ids[m.ordinal()] = i++;
        }
    }

    public MaterialRegistry() {
        this(Material.values());
    }

    public Material getMaterial(int id) {
        try {
            Material m = this.materials[id];
            assert (m != null);
            return m;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("invalid material id");
        }
    }

    public int getId(Material material) {
        try {
            return this.ids[material.ordinal()];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new AssertionError((Object)"material registry out-of-date");
        }
    }

    public Material[] getMaterials() {
        return this.materials;
    }
}

