/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.Arrays;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Unbreakable Items")
@Description(value={"Creates unbreakable copies of given items."})
@Examples(value={"unbreakable iron sword #Creates unbreakable iron sword"})
@Since(value="2.2-dev13b")
public class ExprUnbreakable
extends PropertyExpression<ItemType, ItemType> {
    private static final boolean USE_DEPRECATED_METHOD = !Skript.methodExists(ItemMeta.class, "setUnbreakable", Boolean.TYPE);

    static {
        Skript.registerExpression(ExprUnbreakable.class, ItemType.class, ExpressionType.PROPERTY, "unbreakable %itemtypes%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        return true;
    }

    protected ItemType[] get(Event e, ItemType[] source) {
        return this.get(source, itemType -> {
            ItemType clone = itemType.clone();
            ItemMeta meta = clone.getItemMeta();
            if (meta == null) {
                ItemStack random = clone.getRandom();
                if (random == null) {
                    return clone;
                }
                meta = random.getItemMeta();
            }
            if (USE_DEPRECATED_METHOD) {
                meta.spigot().setUnbreakable(true);
            } else {
                meta.setUnbreakable(true);
            }
            clone.setItemMeta(meta);
            return clone;
        });
    }

    @Override
    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        if (e == null) {
            return "unbreakable items";
        }
        return "unbreakable " + Arrays.toString(this.getExpr().getAll(e));
    }
}

