/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.registrations.Converters;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.event.Event;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.metadata.Metadatable;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Metadata")
@Description(value={"Metadata is a way to store temporary data on entities, blocks and more thatdisappears after a server restart."})
@Examples(value={"set metadata value \"healer\" of player to true", "broadcast \"%metadata value \"\"healer\"\" of player%\"", "clear metadata value \"healer\" of player"})
@Since(value="2.2-dev36")
public class ExprMetadata<T>
extends SimpleExpression<T> {
    private ExprMetadata<?> source;
    @Nullable
    private Expression<String> values;
    @Nullable
    private Expression<Metadatable> holders;
    private Class<T> superType;

    static {
        Skript.registerExpression(ExprMetadata.class, Object.class, ExpressionType.PROPERTY, "metadata [(value|tag)[s]] %strings% of %metadataholders%", "%metadataholders%'[s] metadata [(value|tag)[s]] %string%");
    }

    public ExprMetadata() {
        this(null, Object.class);
    }

    private ExprMetadata(ExprMetadata<?> source, Class<? extends T> ... types) {
        this.source = source;
        if (source != null) {
            this.values = source.values;
            this.holders = source.holders;
        }
        this.superType = Utils.getSuperType(types);
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.holders = exprs[matchedPattern ^ 1];
        this.values = exprs[matchedPattern];
        return true;
    }

    @Override
    @Nullable
    protected T[] get(Event e) {
        ArrayList<Object> values = new ArrayList<Object>();
        String[] stringArray = this.values.getArray(e);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            Metadatable[] metadatableArray = this.holders.getArray(e);
            int n3 = metadatableArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Metadatable holder = metadatableArray[n4];
                List metadata = holder.getMetadata(value);
                if (!metadata.isEmpty()) {
                    values.add(((MetadataValue)metadata.get(metadata.size() - 1)).value());
                }
                ++n4;
            }
            ++n2;
        }
        try {
            return Converters.convertStrictly(values.toArray(), this.superType);
        }
        catch (ClassCastException e1) {
            return (Object[])Array.newInstance(this.superType, 0);
        }
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.SET) {
            return CollectionUtils.array(Object.class);
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        String[] stringArray = this.values.getArray(e);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            Metadatable[] metadatableArray = this.holders.getArray(e);
            int n3 = metadatableArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Metadatable holder = metadatableArray[n4];
                switch (mode) {
                    case SET: {
                        holder.setMetadata(value, (MetadataValue)new FixedMetadataValue((Plugin)Skript.getInstance(), delta[0]));
                        break;
                    }
                    case DELETE: {
                        holder.removeMetadata(value, (Plugin)Skript.getInstance());
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    @Override
    public boolean isSingle() {
        return this.holders.isSingle() && this.values.isSingle();
    }

    @Override
    public Class<? extends T> getReturnType() {
        return this.superType;
    }

    @Override
    public <R> Expression<? extends R> getConvertedExpression(Class<R> ... to) {
        return new ExprMetadata<R>(this, to);
    }

    @Override
    public Expression<?> getSource() {
        return this.source == null ? this : this.source;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "metadata values " + this.values.toString(e, debug) + " of " + this.holders.toString(e, debug);
    }
}

