/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Checker;
import org.bukkit.GameMode;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.eclipse.jdt.annotation.Nullable;

public final class EvtGameMode
extends SkriptEvent {
    @Nullable
    private Literal<GameMode> mode;

    static {
        Skript.registerEvent("Gamemode Change", EvtGameMode.class, PlayerGameModeChangeEvent.class, "game[ ]mode change [to %gamemode%]").description("Called when a player's <a href='../classes.html#gamemode'>gamemode</a> changes.").examples("on gamemode change", "on gamemode change to adventure").since("1.0");
    }

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        this.mode = args[0];
        return true;
    }

    @Override
    public boolean check(final Event e) {
        if (this.mode != null) {
            return this.mode.check(e, new Checker<GameMode>(){

                @Override
                public boolean check(GameMode m) {
                    return ((PlayerGameModeChangeEvent)e).getNewGameMode().equals((Object)m);
                }
            });
        }
        return true;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "gamemode change" + (this.mode != null ? " to " + this.mode.toString().toLowerCase() : "");
    }
}

