/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.localization.ArgsMessage;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.Checker;
import ch.njol.util.coll.CollectionUtils;
import java.util.Arrays;
import org.bukkit.entity.Enderman;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.eclipse.jdt.annotation.Nullable;

public class EndermanData
extends EntityData<Enderman> {
    @Nullable
    private ItemType[] hand = null;
    private static final ArgsMessage format;

    static {
        EntityData.register(EndermanData.class, "enderman", Enderman.class, "enderman");
        format = new ArgsMessage("entities.enderman.format");
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        if (exprs[0] != null) {
            this.hand = (ItemType[])exprs[0].getAll();
        }
        return true;
    }

    @Override
    protected boolean init(@Nullable Class<? extends Enderman> c, @Nullable Enderman e) {
        MaterialData m;
        if (e != null && (m = e.getCarriedMaterial()) != null) {
            ItemStack i = m.toItemStack(1);
            if (i == null) {
                return false;
            }
            this.hand = new ItemType[]{new ItemType(i)};
        }
        return true;
    }

    @Override
    public void set(Enderman entity) {
        if (this.hand != null) {
            ItemType t = CollectionUtils.getRandom(this.hand);
            assert (t != null);
            ItemStack i = t.getBlock().getRandom();
            if (i != null) {
                entity.setCarriedMaterial(i.getData());
            }
        }
    }

    @Override
    public boolean match(final Enderman entity) {
        return this.hand == null || SimpleExpression.check(this.hand, new Checker<ItemType>(){

            @Override
            public boolean check(@Nullable ItemType t) {
                return t != null && t.isOfType(entity.getCarriedMaterial().getItemType());
            }
        }, false, false);
    }

    @Override
    public Class<Enderman> getType() {
        return Enderman.class;
    }

    @Override
    public String toString(int flags) {
        Object[] hand = this.hand;
        if (hand == null) {
            return super.toString(flags);
        }
        return format.toString(super.toString(flags), Classes.toString(hand, false));
    }

    @Override
    protected int hashCode_i() {
        return Arrays.hashCode(this.hand);
    }

    @Override
    protected boolean equals_i(EntityData<?> obj) {
        if (!(obj instanceof EndermanData)) {
            return false;
        }
        EndermanData other = (EndermanData)obj;
        return Arrays.equals(this.hand, other.hand);
    }

    @Override
    @Deprecated
    protected boolean deserialize(String s) {
        if (s.isEmpty()) {
            return true;
        }
        String[] split = s.split("(?<!,),(?!,)");
        this.hand = new ItemType[split.length];
        int i = 0;
        while (i < this.hand.length) {
            String[] t = split[i].split("(?<!:):(?::)");
            if (t.length != 2) {
                return false;
            }
            Object o = Classes.deserialize(t[0], t[1].replace(",,", ",").replace("::", ":"));
            if (o == null || !(o instanceof ItemType)) {
                return false;
            }
            this.hand[i] = (ItemType)o;
            ++i;
        }
        return false;
    }

    private boolean isSubhand(@Nullable ItemType[] sub) {
        if (this.hand != null) {
            return sub != null && ItemType.isSubset(this.hand, sub);
        }
        return true;
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> e) {
        if (e instanceof EndermanData) {
            return this.isSubhand(((EndermanData)e).hand);
        }
        return false;
    }

    @Override
    public EntityData getSuperType() {
        return new EndermanData();
    }
}

