/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Toggle Flight")
@Description(value={"Toggle the <a href='expressions.html#ExprFlightMode'>flight mode</a> of a player."})
@Examples(value={"allow flight to event-player"})
@Since(value="INSERT VERSION")
public class EffToggleFlight
extends Effect {
    private Expression<Player> players;
    private boolean allow;

    static {
        Skript.registerEffect(EffToggleFlight.class, "(allow|enable) (fly|flight) (for|to) %players%", "(disallow|disable) (fly|flight) (for|to) %players%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.players = exprs[0];
        this.allow = matchedPattern == 0;
        return true;
    }

    @Override
    protected void execute(Event e) {
        Player[] playerArray = this.players.getArray(e);
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player player = playerArray[n2];
            player.setAllowFlight(this.allow);
            ++n2;
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "allow flight to " + this.players.toString(e, debug);
    }
}

