/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.ExprHiddenPlayers;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Player Visibility")
@Description(value={"Change visibility of a player for the given players.", "When reveal is used in combination of the <a href='expressions.html#ExprHiddenPlayers'>hidden players</a> expression and the viewers are not specified, this will default it to the given player in the hidden players expression.", "", "Note: if a player was hidden and relogs, this player will be visible again."})
@Examples(value={"on join:", "\tif {vanished::%player's uuid%} is true:", "\t\thide the player from all players", "", "reveal hidden players of {_player}"})
@Since(value="INSERT VERSION")
public class EffPlayerVisibility
extends Effect {
    private static final boolean USE_DEPRECATED_METHOD = !Skript.methodExists(Player.class, "hidePlayer", Plugin.class, Player.class);
    private Expression<Player> players;
    private Expression<Player> targetPlayers;
    private boolean reveal;

    static {
        Skript.registerEffect(EffPlayerVisibility.class, "hide %players% [(from|for) %-players%]", "reveal %players% [(to|for|from) %-players%]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.reveal = matchedPattern == 1;
        this.players = exprs[0];
        this.targetPlayers = this.reveal && this.players instanceof ExprHiddenPlayers ? (exprs.length > 1 ? exprs[1] : ((ExprHiddenPlayers)this.players).getPlayers()) : (exprs.length > 1 ? exprs[1] : null);
        return true;
    }

    @Override
    protected void execute(Event e) {
        Player[] targets;
        Player[] playerArray = targets = this.targetPlayers == null ? Bukkit.getOnlinePlayers().toArray(new Player[0]) : this.targetPlayers.getArray(e);
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            Player targetPlayer = playerArray[n2];
            Player[] playerArray2 = this.players.getArray(e);
            int n3 = playerArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                Player player = playerArray2[n4];
                if (this.reveal) {
                    if (USE_DEPRECATED_METHOD) {
                        targetPlayer.showPlayer(player);
                    } else {
                        targetPlayer.showPlayer((Plugin)Skript.getInstance(), player);
                    }
                } else if (USE_DEPRECATED_METHOD) {
                    targetPlayer.hidePlayer(player);
                } else {
                    targetPlayer.hidePlayer((Plugin)Skript.getInstance(), player);
                }
                ++n4;
            }
            ++n2;
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return String.valueOf(this.reveal ? "show " : "hide ") + this.players.toString(e, debug) + (this.reveal ? " to " : " from ") + this.targetPlayers.toString(e, debug);
    }
}

