/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.SkriptCommand;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import java.io.File;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Is Script Loaded")
@Description(value={"Check if the current script or another script, is current loaded."})
@Examples(value={"script is loaded", "script \"example.sk\" is loaded"})
@Since(value="2.2-dev31")
public class CondScriptLoaded
extends Condition {
    @Nullable
    private Expression<String> scripts;
    @Nullable
    private File currentScriptFile;

    static {
        Skript.registerCondition(CondScriptLoaded.class, "script[s] [%-strings%] (is|are) loaded", "script[s] [%-strings%] (isn't|is not|aren't|are not) loaded");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        assert (ScriptLoader.currentScript != null);
        this.currentScriptFile = ScriptLoader.currentScript.getFile();
        this.scripts = exprs[0];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    @Override
    public boolean check(Event e) {
        if (this.scripts == null) {
            return ScriptLoader.getLoadedFiles().contains(this.currentScriptFile);
        }
        assert (this.scripts != null);
        return this.scripts.check(e, new Checker<String>(){

            @Override
            public boolean check(String scriptName) {
                return ScriptLoader.getLoadedFiles().contains(SkriptCommand.getScriptFromName(scriptName));
            }
        }, this.isNegated());
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        String scriptName = this.scripts == null ? "script" : (this.scripts.isSingle() ? "script" : "scripts " + this.scripts.toString(e, debug));
        boolean isSingle = this.scripts == null || this.scripts.isSingle();
        return String.valueOf(scriptName) + " " + (isSingle ? (this.isNegated() ? "isn't" : "is") : (this.isNegated() ? "aren't" : "are")) + " loaded";
    }
}

