/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Has Client Weather")
@Description(value={"Checks whether the given players have a custom client weather"})
@Examples(value={"if the player has custom weather:", "\tmessage \"Your custom weather is %player's weather%\""})
@Since(value="INSERT VERSION")
public class CondHasClientWeather
extends Condition {
    private Expression<Player> players;

    static {
        Skript.registerCondition(CondHasClientWeather.class, "%players% (has|have) [a] (client|custom) weather [set]", "%players% do[es](n't| not) have [a] (client|custom) weather [set]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setNegated(matchedPattern == 1);
        this.players = exprs[0];
        return true;
    }

    @Override
    public boolean check(Event e) {
        return this.players.check(e, player -> player.getPlayerWeather() != null, this.isNegated());
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return String.valueOf(this.players.toString(e, debug)) + (this.isNegated() ? " have " : " don't have ") + " custom weather";
    }
}

