/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.SkriptEventHandler;
import ch.njol.skript.aliases.Aliases;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.command.CommandEvent;
import ch.njol.skript.command.Commands;
import ch.njol.skript.command.ScriptCommand;
import ch.njol.skript.config.Config;
import ch.njol.skript.config.EntryNode;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.config.SimpleNode;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.events.bukkit.PreScriptLoadEvent;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Conditional;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Loop;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SelfRegisteringSkriptEvent;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptEventInfo;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Statement;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.TriggerSection;
import ch.njol.skript.lang.While;
import ch.njol.skript.lang.function.Function;
import ch.njol.skript.lang.function.FunctionEvent;
import ch.njol.skript.lang.function.Functions;
import ch.njol.skript.lang.function.Signature;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.Message;
import ch.njol.skript.localization.PluralizingArgsMessage;
import ch.njol.skript.log.CountingLogHandler;
import ch.njol.skript.log.ErrorDescLogHandler;
import ch.njol.skript.log.LogEntry;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.Converters;
import ch.njol.skript.util.Date;
import ch.njol.skript.util.ExceptionUtils;
import ch.njol.skript.util.Task;
import ch.njol.skript.variables.TypeHints;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Callback;
import ch.njol.util.Kleenean;
import ch.njol.util.NonNullPair;
import ch.njol.util.StringUtils;
import ch.njol.util.Validate;
import ch.njol.util.coll.CollectionUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class ScriptLoader {
    private static final Message m_no_errors = new Message("skript.no errors");
    private static final Message m_no_scripts = new Message("skript.no scripts");
    private static final PluralizingArgsMessage m_scripts_loaded = new PluralizingArgsMessage("skript.scripts loaded");
    @Nullable
    public static Config currentScript = null;
    private static boolean callPreLoadEvent;
    private static Set<SkriptAddon> preloadListeners;
    @Nullable
    private static String currentEventName;
    @Nullable
    private static Class<? extends Event>[] currentEvents;
    public static List<TriggerSection> currentSections;
    public static List<Loop> currentLoops;
    private static final Map<String, ItemType> currentAliases;
    static final HashMap<String, String> currentOptions;
    private static final ScriptInfo loadedScripts;
    public static Kleenean hasDelayBefore;
    private static String indentation;
    static final BlockingQueue<Runnable> loadQueue;
    static final Thread loaderThread;
    static boolean loadAsync;
    static final Set<File> loadedFiles;
    private static final FileFilter scriptFilter;

    static {
        preloadListeners = new HashSet<SkriptAddon>();
        currentEventName = null;
        currentEvents = null;
        currentSections = new ArrayList<TriggerSection>();
        currentLoops = new ArrayList<Loop>();
        currentAliases = new HashMap<String, ItemType>();
        currentOptions = new HashMap();
        loadedScripts = new ScriptInfo();
        hasDelayBefore = Kleenean.FALSE;
        indentation = "";
        loadQueue = new ArrayBlockingQueue<Runnable>(20, true);
        loadedFiles = Collections.synchronizedSet(new HashSet());
        loaderThread = new AsyncLoaderThread();
        loaderThread.start();
        scriptFilter = new FileFilter(){

            @Override
            public boolean accept(@Nullable File f) {
                return f != null && (f.isDirectory() || StringUtils.endsWithIgnoreCase(f.getName(), ".sk")) && !f.getName().startsWith("-");
            }
        };
    }

    private ScriptLoader() {
    }

    public static void setCallPreloadEvent(boolean state, @NonNull SkriptAddon addon) {
        Validate.notNull(addon);
        callPreLoadEvent = state;
        if (state) {
            preloadListeners.add(addon);
        } else {
            preloadListeners.remove(addon);
        }
    }

    public static boolean getCallPreloadEvent() {
        return callPreLoadEvent;
    }

    public static Set<SkriptAddon> getPreloadListeners() {
        return Collections.unmodifiableSet(preloadListeners);
    }

    @Nullable
    public static String getCurrentEventName() {
        return currentEventName;
    }

    public static void setCurrentEvent(String name, Class<? extends Event> ... events) {
        currentEventName = name;
        currentEvents = events;
        hasDelayBefore = Kleenean.FALSE;
    }

    public static void deleteCurrentEvent() {
        currentEventName = null;
        currentEvents = null;
        hasDelayBefore = Kleenean.FALSE;
    }

    public static Map<String, ItemType> getScriptAliases() {
        return currentAliases;
    }

    public static boolean isAsync() {
        return loadAsync;
    }

    public static Collection<File> getLoadedFiles() {
        return Collections.unmodifiableCollection(loadedFiles);
    }

    static void loadScripts() {
        File scriptsFolder = new File(Skript.getInstance().getDataFolder(), "scripts" + File.separator);
        if (!scriptsFolder.isDirectory()) {
            scriptsFolder.mkdirs();
        }
        Date start = new Date();
        Runnable task = () -> {
            ScriptInfo i;
            HashSet<File> oldLoadedFiles = new HashSet<File>(loadedFiles);
            ErrorDescLogHandler h = SkriptLogger.startLogHandler(new ErrorDescLogHandler(null, null, m_no_errors.toString()));
            try {
                Language.setUseLocal(false);
                List<Config> configs = ScriptLoader.loadStructures(scriptsFolder);
                i = ScriptLoader.loadScripts(configs);
            }
            finally {
                Language.setUseLocal(true);
                h.stop();
            }
            if (loadAsync) {
                oldLoadedFiles.removeAll(loadedFiles);
                for (File script : oldLoadedFiles) {
                    assert (script != null);
                    ScriptLoader.unloadScript_(script);
                    Functions.clearFunctions(script);
                }
                Functions.validateFunctions();
            }
            if (i.files == 0) {
                Skript.warning(m_no_scripts.toString());
            }
            if (Skript.logNormal() && i.files > 0) {
                Skript.info(m_scripts_loaded.toString(i.files, i.triggers, i.commands, start.difference(new Date())));
            }
            SkriptEventHandler.registerBukkitEvents();
        };
        if (loadAsync) {
            loadQueue.add(task);
        } else {
            task.run();
        }
    }

    public static final ScriptInfo loadScripts(List<Config> configs) {
        ScriptInfo i = new ScriptInfo();
        Runnable task = () -> {
            boolean wasLocal = Language.setUseLocal(false);
            try {
                for (Config cfg : configs) {
                    assert (cfg != null) : configs.toString();
                    i.add(ScriptLoader.loadScript(cfg));
                }
            }
            finally {
                if (wasLocal) {
                    Language.setUseLocal(true);
                }
            }
            SkriptEventHandler.registerBukkitEvents();
        };
        if (loadAsync && Bukkit.isPrimaryThread()) {
            loadQueue.add(task);
        } else {
            task.run();
        }
        return i;
    }

    public static final ScriptInfo loadScripts(List<Config> configs, List<LogEntry> logOut) {
        RetainingLogHandler logHandler = SkriptLogger.startRetainingLog();
        try {
            ScriptInfo scriptInfo = ScriptLoader.loadScripts(configs);
            return scriptInfo;
        }
        finally {
            logOut.addAll(logHandler.getLog());
            logHandler.clear();
            logHandler.printLog();
        }
    }

    public static final ScriptInfo loadScripts(Config ... configs) {
        return ScriptLoader.loadScripts(Arrays.asList(configs));
    }

    @Deprecated
    public static final ScriptInfo loadScripts(File ... files) {
        List<Config> configs = ScriptLoader.loadStructures(files);
        return ScriptLoader.loadScripts(configs);
    }

    private static final ScriptInfo loadScript(final @Nullable Config config) {
        int numFunctions;
        int numCommands;
        int numTriggers;
        ArrayList<ParsedEventData> events;
        ArrayList functions;
        ArrayList<ScriptCommand> commands;
        block52: {
            if (config == null) {
                return new ScriptInfo();
            }
            commands = new ArrayList<ScriptCommand>();
            functions = new ArrayList();
            events = new ArrayList<ParsedEventData>();
            numTriggers = 0;
            numCommands = 0;
            numFunctions = 0;
            try {
                try {
                    if (SkriptConfig.keepConfigsLoaded.value().booleanValue()) {
                        SkriptConfig.configs.add(config);
                    }
                    currentAliases.clear();
                    currentOptions.clear();
                    currentScript = config;
                    if (callPreLoadEvent) {
                        Bukkit.getPluginManager().callEvent((Event)new PreScriptLoadEvent(config));
                    }
                    CountingLogHandler numErrors = SkriptLogger.startLogHandler(new CountingLogHandler(SkriptLogger.SEVERE));
                    try {
                        for (Node cnode : config.getMainNode()) {
                            NonNullPair<SkriptEventInfo<?>, SkriptEvent> parsedEvent;
                            if (!(cnode instanceof SectionNode)) {
                                Skript.error("invalid line - all code has to be put into triggers");
                                continue;
                            }
                            SectionNode node = (SectionNode)cnode;
                            String event = node.getKey();
                            if (event == null) continue;
                            if (event.equalsIgnoreCase("aliases")) {
                                node.convertToEntries(0, "=");
                                for (Node n : node) {
                                    if (!(n instanceof EntryNode)) {
                                        Skript.error("invalid line in aliases section");
                                        continue;
                                    }
                                    ItemType t = Aliases.parseAlias(((EntryNode)n).getValue());
                                    if (t == null) continue;
                                    currentAliases.put(((EntryNode)n).getKey().toLowerCase(), t);
                                }
                                continue;
                            }
                            if (event.equalsIgnoreCase("options")) {
                                node.convertToEntries(0);
                                for (Node n : node) {
                                    if (!(n instanceof EntryNode)) {
                                        Skript.error("invalid line in options");
                                        continue;
                                    }
                                    currentOptions.put(((EntryNode)n).getKey(), ((EntryNode)n).getValue());
                                }
                                continue;
                            }
                            if (event.equalsIgnoreCase("variables")) {
                                node.convertToEntries(0, "=");
                                for (Node n : node) {
                                    Object o;
                                    String var;
                                    if (!(n instanceof EntryNode)) {
                                        Skript.error("Invalid line in variables section");
                                        continue;
                                    }
                                    String name = ((EntryNode)n).getKey().toLowerCase(Locale.ENGLISH);
                                    if (name.startsWith("{") && name.endsWith("}")) {
                                        name = name.substring(1, name.length() - 1);
                                    }
                                    if ((name = StringUtils.replaceAll((CharSequence)name, "%(.+)?%", new Callback<String, Matcher>(var = name){
                                        private final /* synthetic */ String val$var;
                                        {
                                            this.val$var = string;
                                        }

                                        @Override
                                        @Nullable
                                        public String run(Matcher m) {
                                            if (m.group(1).contains("{") || m.group(1).contains("}") || m.group(1).contains("%")) {
                                                Skript.error("'" + this.val$var + "' is not a valid name for a default variable");
                                                return null;
                                            }
                                            ClassInfo<?> ci = Classes.getClassInfoFromUserInput(m.group(1));
                                            if (ci == null) {
                                                Skript.error("Can't understand the type '" + m.group(1) + "'");
                                                return null;
                                            }
                                            return "<" + ci.getCodeName() + ">";
                                        }
                                    })) == null) continue;
                                    if (name.contains("%")) {
                                        Skript.error("Invalid use of percent signs in variable name");
                                        continue;
                                    }
                                    if (Variables.getVariable(name, null, false) != null) continue;
                                    ParseLogHandler log = SkriptLogger.startParseLogHandler();
                                    try {
                                        o = Classes.parseSimple(((EntryNode)n).getValue(), Object.class, ParseContext.SCRIPT);
                                        if (o == null) {
                                            log.printError("Can't understand the value '" + ((EntryNode)n).getValue() + "'");
                                            continue;
                                        }
                                        log.printLog();
                                    }
                                    finally {
                                        log.stop();
                                    }
                                    ClassInfo<?> ci = Classes.getSuperClassInfo(o.getClass());
                                    if (ci.getSerializer() == null) {
                                        Skript.error("Can't save '" + ((EntryNode)n).getValue() + "' in a variable");
                                        continue;
                                    }
                                    if (ci.getSerializeAs() != null) {
                                        ClassInfo<?> as = Classes.getExactClassInfo(ci.getSerializeAs());
                                        if (as == null) {
                                            assert (false) : ci;
                                            continue;
                                        }
                                        if ((o = Converters.convert(o, as.getC())) == null) {
                                            Skript.error("Can't save '" + ((EntryNode)n).getValue() + "' in a variable");
                                            continue;
                                        }
                                    }
                                    Variables.setVariable(name, o, null, false);
                                }
                                continue;
                            }
                            if (!SkriptParser.validateLine(event)) continue;
                            if (event.toLowerCase().startsWith("command ")) {
                                ScriptLoader.setCurrentEvent("command", CommandEvent.class);
                                ScriptCommand c = Commands.loadCommand(node, false);
                                if (c != null) {
                                    commands.add(c);
                                }
                                ++numCommands;
                                ScriptLoader.deleteCurrentEvent();
                                continue;
                            }
                            if (event.toLowerCase().startsWith("function ")) {
                                ScriptLoader.setCurrentEvent("function", FunctionEvent.class);
                                Function<?> func = Functions.loadFunction(node);
                                if (func != null) {
                                    functions.add(func);
                                }
                                ++numFunctions;
                                ScriptLoader.deleteCurrentEvent();
                                continue;
                            }
                            if (Skript.logVeryHigh() && !Skript.debug()) {
                                Skript.info("loading trigger '" + event + "'");
                            }
                            if (StringUtils.startsWithIgnoreCase(event, "on ")) {
                                event = event.substring("on ".length());
                            }
                            if ((parsedEvent = SkriptParser.parseEvent(event = ScriptLoader.replaceOptions(event), "can't understand this event: '" + node.getKey() + "'")) == null) continue;
                            if (Skript.debug() || node.debug()) {
                                Skript.debug(String.valueOf(event) + " (" + parsedEvent.getSecond().toString(null, true) + "):");
                            }
                            try {
                                ScriptLoader.setCurrentEvent(parsedEvent.getFirst().getName().toLowerCase(Locale.ENGLISH), parsedEvent.getFirst().events);
                                events.add(new ParsedEventData(parsedEvent, event, node, ScriptLoader.loadItems(node)));
                            }
                            finally {
                                ScriptLoader.deleteCurrentEvent();
                            }
                            if (parsedEvent.getSecond() instanceof SelfRegisteringSkriptEvent) {
                                ((SelfRegisteringSkriptEvent)parsedEvent.getSecond()).afterParse(config);
                            }
                            ++numTriggers;
                        }
                        if (Skript.logHigh()) {
                            Skript.info("loaded " + numTriggers + " trigger" + (numTriggers == 1 ? "" : "s") + " and " + numCommands + " command" + (numCommands == 1 ? "" : "s") + " from '" + config.getFileName() + "'");
                        }
                        currentScript = null;
                    }
                    finally {
                        numErrors.stop();
                    }
                }
                catch (Exception e) {
                    Skript.exception((Throwable)e, "Could not load " + config.getFileName());
                    SkriptLogger.setNode(null);
                    break block52;
                }
            }
            catch (Throwable throwable) {
                SkriptLogger.setNode(null);
                throw throwable;
            }
            SkriptLogger.setNode(null);
        }
        Callable<Void> callable = new Callable<Void>(){

            @Override
            @Nullable
            public Void call() throws Exception {
                File file = config.getFile();
                if (loadAsync && file != null) {
                    ScriptLoader.unloadScript_(file);
                }
                for (ScriptCommand command : commands) {
                    if (!$assertionsDisabled && command == null) {
                        throw new AssertionError();
                    }
                    Commands.registerCommand(command);
                }
                for (Function func : functions) {
                    if (!$assertionsDisabled && func == null) {
                        throw new AssertionError();
                    }
                    Functions.putFunction(func);
                }
                for (ParsedEventData event : events) {
                    Trigger trigger;
                    ScriptLoader.setCurrentEvent(event.info.getFirst().getName().toLowerCase(Locale.ENGLISH), event.info.getFirst().events);
                    try {
                        trigger = new Trigger(config.getFile(), event.event, event.info.getSecond(), event.items);
                        trigger.setLineNumber(event.node.getLine());
                        trigger.setDebugLabel(String.valueOf(config.getFileName()) + ": line " + event.node.getLine());
                    }
                    finally {
                        ScriptLoader.deleteCurrentEvent();
                    }
                    if (event.info.getSecond() instanceof SelfRegisteringSkriptEvent) {
                        ((SelfRegisteringSkriptEvent)event.info.getSecond()).register(trigger);
                        SkriptEventHandler.addSelfRegisteringTrigger(trigger);
                    } else {
                        SkriptEventHandler.addTrigger(event.info.getFirst().events, trigger);
                    }
                    ScriptLoader.deleteCurrentEvent();
                }
                loadedFiles.add(file);
                return null;
            }
        };
        if (loadAsync) {
            Task.callSync(callable);
        } else {
            try {
                callable.call();
            }
            catch (Exception e) {
                Skript.exception((Throwable)e, new String[0]);
            }
        }
        return new ScriptInfo(1, numTriggers, numCommands, numFunctions);
    }

    public static final List<Config> loadStructures(File[] files) {
        Arrays.sort(files);
        ArrayList<Config> loadedFiles = new ArrayList<Config>(files.length);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            assert (f != null) : Arrays.toString(files);
            loadedFiles.add(ScriptLoader.loadStructure(f));
            ++n2;
        }
        return loadedFiles;
    }

    public static List<Config> loadStructures(File directory) {
        if (!directory.isDirectory()) {
            return ScriptLoader.loadStructures(new File[]{directory});
        }
        Object[] files = directory.listFiles(scriptFilter);
        Arrays.sort(files);
        ArrayList<Config> loadedFiles = new ArrayList<Config>(files.length);
        Object[] objectArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            Object f = objectArray[n2];
            if (((File)f).isDirectory()) {
                loadedFiles.addAll(ScriptLoader.loadStructures((File)f));
            } else {
                loadedFiles.add(ScriptLoader.loadStructure((File)f));
            }
            ++n2;
        }
        return loadedFiles;
    }

    @Nullable
    public static final Config loadStructure(File f) {
        if (!f.exists()) {
            ScriptLoader.unloadScript(f);
            return null;
        }
        try {
            String name = Skript.getInstance().getDataFolder().toPath().resolve("scripts").relativize(f.toPath()).toString();
            assert (name != null);
            return ScriptLoader.loadStructure(new FileInputStream(f), name);
        }
        catch (IOException e) {
            Skript.error("Could not load " + f.getName() + ": " + ExceptionUtils.toString(e));
            return null;
        }
    }

    @Nullable
    public static final Config loadStructure(InputStream source, String name) {
        try {
            Config config = new Config(source, name, Skript.getInstance().getDataFolder().toPath().resolve("scripts").resolve(name).toFile(), true, false, ":");
            return ScriptLoader.loadStructure(config);
        }
        catch (IOException e) {
            Skript.error("Could not load " + name + ": " + ExceptionUtils.toString(e));
            return null;
        }
    }

    @Nullable
    public static final Config loadStructure(Config config) {
        try {
            for (Node cnode : config.getMainNode()) {
                SectionNode node;
                String event;
                if (!(cnode instanceof SectionNode) || (event = (node = (SectionNode)cnode).getKey()) == null || !SkriptParser.validateLine(event) || !event.toLowerCase().startsWith("function ")) continue;
                ScriptLoader.setCurrentEvent("function", FunctionEvent.class);
                Signature<?> func = Functions.loadSignature(config.getFileName(), node);
                ScriptLoader.deleteCurrentEvent();
            }
            currentScript = null;
            SkriptLogger.setNode(null);
            Config config2 = config;
            return config2;
        }
        catch (Exception e) {
            Skript.exception((Throwable)e, "Could not load " + config.getFileName());
        }
        finally {
            SkriptLogger.setNode(null);
        }
        return null;
    }

    static final ScriptInfo unloadScripts(File folder) {
        ScriptInfo r = ScriptLoader.unloadScripts_(folder);
        Functions.validateFunctions();
        return r;
    }

    private static final ScriptInfo unloadScripts_(File folder) {
        File[] files;
        ScriptInfo info = new ScriptInfo();
        File[] fileArray = files = folder.listFiles(scriptFilter);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                info.add(ScriptLoader.unloadScripts_(f));
            } else if (f.getName().endsWith(".sk")) {
                info.add(ScriptLoader.unloadScript_(f));
            }
            ++n2;
        }
        return info;
    }

    static final ScriptInfo unloadScript(File script) {
        ScriptInfo r = ScriptLoader.unloadScript_(script);
        Functions.clearFunctions(script);
        Functions.validateFunctions();
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ScriptInfo unloadScript_(File script) {
        if (loadedFiles.contains(script)) {
            ScriptInfo info = SkriptEventHandler.removeTriggers(script);
            ScriptInfo scriptInfo = loadedScripts;
            synchronized (scriptInfo) {
                loadedScripts.subtract(info);
            }
            loadedFiles.remove(script);
            return info;
        }
        return new ScriptInfo();
    }

    public static final String replaceOptions(String s) {
        String r = StringUtils.replaceAll((CharSequence)s, "\\{@(.+?)\\}", new Callback<String, Matcher>(){

            @Override
            @Nullable
            public String run(Matcher m) {
                String option = currentOptions.get(m.group(1));
                if (option == null) {
                    Skript.error("undefined option " + m.group());
                    return m.group();
                }
                return Matcher.quoteReplacement(option);
            }
        });
        assert (r != null);
        return r;
    }

    public static ArrayList<TriggerItem> loadItems(SectionNode node) {
        if (Skript.debug()) {
            indentation = String.valueOf(indentation) + "    ";
        }
        ArrayList<TriggerItem> items = new ArrayList<TriggerItem>();
        Kleenean hadDelayBeforeLastIf = Kleenean.FALSE;
        for (Node n : node) {
            Condition cond;
            String l;
            String name;
            SkriptLogger.setNode(n);
            if (n instanceof SimpleNode) {
                Statement stmt;
                SimpleNode e = (SimpleNode)n;
                String s = ScriptLoader.replaceOptions(e.getKey());
                if (!SkriptParser.validateLine(s) || (stmt = Statement.parse(s, "Can't understand this condition/effect: " + s)) == null) continue;
                if (Skript.debug() || n.debug()) {
                    Skript.debug(String.valueOf(indentation) + stmt.toString(null, true));
                }
                items.add(stmt);
                if (!(stmt instanceof Delay)) continue;
                hasDelayBefore = Kleenean.TRUE;
                continue;
            }
            if (!(n instanceof SectionNode) || !SkriptParser.validateLine(name = ScriptLoader.replaceOptions(n.getKey()))) continue;
            TypeHints.enterScope();
            if (StringUtils.startsWithIgnoreCase(name, "loop ")) {
                Expression<Object> loopedExpr;
                l = name.substring("loop ".length());
                RetainingLogHandler h = SkriptLogger.startRetainingLog();
                try {
                    loopedExpr = new SkriptParser(l).parseExpression(Object.class);
                    if (loopedExpr != null) {
                        loopedExpr = loopedExpr.getConvertedExpression(Object.class);
                    }
                    if (loopedExpr == null) {
                        h.printErrors("Can't understand this loop: '" + name + "'");
                        continue;
                    }
                    h.printLog();
                }
                finally {
                    h.stop();
                }
                if (loopedExpr.isSingle()) {
                    Skript.error("Can't loop " + loopedExpr + " because it's only a single value");
                    continue;
                }
                if (Skript.debug() || n.debug()) {
                    Skript.debug(String.valueOf(indentation) + "loop " + loopedExpr.toString(null, true) + ":");
                }
                Kleenean hadDelayBefore = hasDelayBefore;
                items.add(new Loop(loopedExpr, (SectionNode)n));
                if (hadDelayBefore != Kleenean.TRUE && hasDelayBefore != Kleenean.FALSE) {
                    hasDelayBefore = Kleenean.UNKNOWN;
                }
            } else if (StringUtils.startsWithIgnoreCase(name, "while ")) {
                l = name.substring("while ".length());
                Condition c = Condition.parse(l, "Can't understand this condition: " + l);
                if (c == null) continue;
                if (Skript.debug() || n.debug()) {
                    Skript.debug(String.valueOf(indentation) + "while " + c.toString(null, true) + ":");
                }
                Kleenean hadDelayBefore = hasDelayBefore;
                items.add(new While(c, (SectionNode)n));
                if (hadDelayBefore != Kleenean.TRUE && hasDelayBefore != Kleenean.FALSE) {
                    hasDelayBefore = Kleenean.UNKNOWN;
                }
            } else if (name.equalsIgnoreCase("else")) {
                if (items.size() == 0 || !(items.get(items.size() - 1) instanceof Conditional) || ((Conditional)items.get(items.size() - 1)).hasElseClause()) {
                    Skript.error("'else' has to be placed just after an 'if' or 'else if' section");
                    continue;
                }
                if (Skript.debug() || n.debug()) {
                    Skript.debug(String.valueOf(indentation) + "else:");
                }
                Kleenean hadDelayAfterLastIf = hasDelayBefore;
                hasDelayBefore = hadDelayBeforeLastIf;
                ((Conditional)items.get(items.size() - 1)).loadElseClause((SectionNode)n);
                hasDelayBefore = hadDelayBeforeLastIf.or(hadDelayAfterLastIf.and(hasDelayBefore));
            } else if (StringUtils.startsWithIgnoreCase(name, "else if ")) {
                if (items.size() == 0 || !(items.get(items.size() - 1) instanceof Conditional) || ((Conditional)items.get(items.size() - 1)).hasElseClause()) {
                    Skript.error("'else if' has to be placed just after another 'if' or 'else if' section");
                    continue;
                }
                cond = Condition.parse(name = name.substring("else if ".length()), "can't understand this condition: '" + name + "'");
                if (cond == null) continue;
                if (Skript.debug() || n.debug()) {
                    Skript.debug(String.valueOf(indentation) + "else if " + cond.toString(null, true));
                }
                Kleenean hadDelayAfterLastIf = hasDelayBefore;
                hasDelayBefore = hadDelayBeforeLastIf;
                ((Conditional)items.get(items.size() - 1)).loadElseIf(cond, (SectionNode)n);
                hasDelayBefore = hadDelayBeforeLastIf.or(hadDelayAfterLastIf.and(hasDelayBefore.and(Kleenean.UNKNOWN)));
            } else {
                Kleenean hadDelayBefore;
                if (StringUtils.startsWithIgnoreCase(name, "if ")) {
                    name = name.substring(3);
                }
                if ((cond = Condition.parse(name, "can't understand this condition: '" + name + "'")) == null) continue;
                if (Skript.debug() || n.debug()) {
                    Skript.debug(String.valueOf(indentation) + cond.toString(null, true) + ":");
                }
                hadDelayBeforeLastIf = hadDelayBefore = hasDelayBefore;
                items.add(new Conditional(cond, (SectionNode)n));
                hasDelayBefore = hadDelayBefore.or(hasDelayBefore.and(Kleenean.UNKNOWN));
            }
            TypeHints.exitScope();
        }
        int i = 0;
        while (i < items.size() - 1) {
            ((TriggerItem)items.get(i)).setNext(items.get(i + 1));
            ++i;
        }
        SkriptLogger.setNode(node);
        if (Skript.debug()) {
            indentation = indentation.substring(0, indentation.length() - 4);
        }
        return items;
    }

    @Nullable
    static Trigger loadTrigger(SectionNode node) {
        NonNullPair<SkriptEventInfo<?>, SkriptEvent> parsedEvent;
        String event = node.getKey();
        if (event == null) {
            assert (false) : node;
            return null;
        }
        if (event.toLowerCase().startsWith("on ")) {
            event = event.substring("on ".length());
        }
        if ((parsedEvent = SkriptParser.parseEvent(event, "can't understand this event: '" + node.getKey() + "'")) == null) {
            assert (false);
            return null;
        }
        ScriptLoader.setCurrentEvent("unit test", parsedEvent.getFirst().events);
        try {
            Trigger trigger = new Trigger(null, event, parsedEvent.getSecond(), ScriptLoader.loadItems(node));
            return trigger;
        }
        finally {
            ScriptLoader.deleteCurrentEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int loadedScripts() {
        ScriptInfo scriptInfo = loadedScripts;
        synchronized (scriptInfo) {
            return ScriptLoader.loadedScripts.files;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int loadedCommands() {
        ScriptInfo scriptInfo = loadedScripts;
        synchronized (scriptInfo) {
            return ScriptLoader.loadedScripts.commands;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int loadedFunctions() {
        ScriptInfo scriptInfo = loadedScripts;
        synchronized (scriptInfo) {
            return ScriptLoader.loadedScripts.functions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int loadedTriggers() {
        ScriptInfo scriptInfo = loadedScripts;
        synchronized (scriptInfo) {
            return ScriptLoader.loadedScripts.triggers;
        }
    }

    public static final boolean isCurrentEvent(@Nullable Class<? extends Event> event) {
        return CollectionUtils.containsSuperclass(currentEvents, event);
    }

    @SafeVarargs
    public static final boolean isCurrentEvent(Class<? extends Event> ... events) {
        return CollectionUtils.containsAnySuperclass(currentEvents, events);
    }

    @Nullable
    public static Class<? extends Event>[] getCurrentEvents() {
        return currentEvents;
    }

    private static class AsyncLoaderThread
    extends Thread {
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        loadQueue.take().run();
                    }
                }
                catch (InterruptedException e) {
                    Skript.exception((Throwable)e, new String[0]);
                    continue;
                }
                break;
            }
        }
    }

    private static class ParsedEventData {
        public final NonNullPair<SkriptEventInfo<?>, SkriptEvent> info;
        public final String event;
        public final SectionNode node;
        public final List<TriggerItem> items;

        public ParsedEventData(NonNullPair<SkriptEventInfo<?>, SkriptEvent> info, String event, SectionNode node, List<TriggerItem> items) {
            this.info = info;
            this.event = event;
            this.node = node;
            this.items = items;
        }
    }

    public static class ScriptInfo {
        public int files;
        public int triggers;
        public int commands;
        public int functions;

        public ScriptInfo() {
        }

        public ScriptInfo(int numFiles, int numTriggers, int numCommands, int numFunctions) {
            this.files = numFiles;
            this.triggers = numTriggers;
            this.commands = numCommands;
            this.functions = numFunctions;
        }

        public ScriptInfo(ScriptInfo o) {
            this.files = o.files;
            this.triggers = o.triggers;
            this.commands = o.commands;
            this.functions = o.functions;
        }

        public void add(ScriptInfo other) {
            this.files += other.files;
            this.triggers += other.triggers;
            this.commands += other.commands;
            this.functions += other.functions;
        }

        public void subtract(ScriptInfo other) {
            this.files -= other.files;
            this.triggers -= other.triggers;
            this.commands -= other.commands;
            this.functions -= other.functions;
        }

        public String toString() {
            return "ScriptInfo{files=" + this.files + ",triggers=" + this.triggers + ",commands=" + this.commands + ",functions:" + this.functions + "}";
        }
    }
}

