/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.bukkitutil.PlayerUtils;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Slot;
import java.util.Locale;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

public class EquipmentSlot
extends Slot {
    private final EntityEquipment e;
    private final EquipSlot slot;

    public EquipmentSlot(EntityEquipment e, EquipSlot slot) {
        this.e = e;
        this.slot = slot;
    }

    @Override
    @Nullable
    public ItemStack getItem() {
        return this.slot.get(this.e);
    }

    @Override
    public void setItem(@Nullable ItemStack item) {
        this.slot.set(this.e, item);
        if (this.e.getHolder() instanceof Player) {
            PlayerUtils.updateInventory((Player)this.e.getHolder());
        }
    }

    @Override
    public String toString_i() {
        return "the " + this.slot.name().toLowerCase(Locale.ENGLISH) + " of " + Classes.toString(this.e.getHolder());
    }

    public static enum EquipSlot {
        TOOL{

            @Override
            @Nullable
            public ItemStack get(EntityEquipment e) {
                return e.getItemInHand();
            }

            @Override
            public void set(EntityEquipment e, @Nullable ItemStack item) {
                e.setItemInHand(item);
            }
        }
        ,
        HELMET{

            @Override
            @Nullable
            public ItemStack get(EntityEquipment e) {
                return e.getHelmet();
            }

            @Override
            public void set(EntityEquipment e, @Nullable ItemStack item) {
                e.setHelmet(item);
            }
        }
        ,
        CHESTPLATE{

            @Override
            @Nullable
            public ItemStack get(EntityEquipment e) {
                return e.getChestplate();
            }

            @Override
            public void set(EntityEquipment e, @Nullable ItemStack item) {
                e.setChestplate(item);
            }
        }
        ,
        LEGGINGS{

            @Override
            @Nullable
            public ItemStack get(EntityEquipment e) {
                return e.getLeggings();
            }

            @Override
            public void set(EntityEquipment e, @Nullable ItemStack item) {
                e.setLeggings(item);
            }
        }
        ,
        BOOTS{

            @Override
            @Nullable
            public ItemStack get(EntityEquipment e) {
                return e.getBoots();
            }

            @Override
            public void set(EntityEquipment e, @Nullable ItemStack item) {
                e.setBoots(item);
            }
        };


        @Nullable
        public abstract ItemStack get(EntityEquipment var1);

        public abstract void set(EntityEquipment var1, @Nullable ItemStack var2);
    }
}

