/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.hooks.regions;

import ch.njol.skript.hooks.regions.RegionsPlugin;
import ch.njol.skript.hooks.regions.classes.Region;
import ch.njol.skript.util.AABB;
import ch.njol.skript.variables.Variables;
import ch.njol.util.coll.iterator.EmptyIterator;
import ch.njol.yggdrasil.Fields;
import ch.njol.yggdrasil.YggdrasilID;
import com.massivecraft.factions.Factions;
import com.massivecraft.factions.entity.BoardColl;
import com.massivecraft.factions.entity.BoardColls;
import com.massivecraft.factions.entity.Faction;
import com.massivecraft.factions.entity.FactionColl;
import com.massivecraft.factions.entity.FactionColls;
import com.massivecraft.factions.entity.UPlayer;
import com.massivecraft.factions.listeners.FactionsListenerMain;
import com.massivecraft.massivecore.ps.PS;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.eclipse.jdt.annotation.Nullable;

public class Factions2Hook
extends RegionsPlugin<Factions> {
    static {
        Variables.yggdrasil.registerSingleClass(FactionsRegion.class);
    }

    @Override
    public String getName() {
        return "Factions";
    }

    @Override
    protected boolean init() {
        if (!((Factions)this.plugin).getClass().getName().equals("com.massivecraft.factions.Factions")) {
            return false;
        }
        super.init();
        return true;
    }

    @Override
    public boolean canBuild_i(Player p, Location l) {
        return FactionsListenerMain.canPlayerBuildAt((Player)p, (PS)PS.valueOf((Location)l), (boolean)false);
    }

    @Override
    public Collection<? extends Region> getRegionsAt_i(Location l) {
        return Arrays.asList(new FactionsRegion(BoardColls.get().getFactionAt(PS.valueOf((Location)l))));
    }

    @Override
    @Nullable
    public Region getRegion_i(World world, String name) {
        Faction f = ((FactionColl)FactionColls.get().getForUniverse(world.getName())).getByName(name);
        if (f != null) {
            return new FactionsRegion(f);
        }
        return null;
    }

    @Override
    public boolean hasMultipleOwners_i() {
        return false;
    }

    @Override
    protected Class<? extends Region> getRegionClass() {
        return FactionsRegion.class;
    }

    @YggdrasilID(value="FactionsRegion")
    public final class FactionsRegion
    extends Region {
        private transient Faction faction;

        private FactionsRegion() {
        }

        public FactionsRegion(Faction f) {
            this.faction = f;
        }

        @Override
        public boolean contains(Location l) {
            return BoardColls.get().getFactionAt(PS.valueOf((Location)l)) == this.faction;
        }

        @Override
        public boolean isMember(OfflinePlayer p) {
            for (UPlayer up : this.faction.getUPlayers()) {
                if (!up.getName().equalsIgnoreCase(p.getName())) continue;
                return true;
            }
            return false;
        }

        @Override
        public Collection<OfflinePlayer> getMembers() {
            List ps = this.faction.getUPlayers();
            ArrayList<OfflinePlayer> r = new ArrayList<OfflinePlayer>(ps.size());
            for (UPlayer p : ps) {
                r.add(Bukkit.getOfflinePlayer((UUID)p.getUuid()));
            }
            return r;
        }

        @Override
        public boolean isOwner(OfflinePlayer p) {
            return this.faction.getLeader().getUuid().equals(p.getUniqueId());
        }

        @Override
        public Collection<OfflinePlayer> getOwners() {
            return Arrays.asList(Bukkit.getOfflinePlayer((UUID)this.faction.getLeader().getUuid()));
        }

        @Override
        public Iterator<Block> getBlocks() {
            final Iterator cs = ((BoardColl)BoardColls.get().get((Object)this.faction)).getChunks(this.faction).iterator();
            if (!cs.hasNext()) {
                return EmptyIterator.get();
            }
            return new Iterator<Block>(){
                @Nullable
                Iterator<Block> current;

                @Override
                public boolean hasNext() {
                    Iterator<Block> current = this.current;
                    while ((current == null || !current.hasNext()) && cs.hasNext()) {
                        Chunk c = ((PS)cs.next()).asBukkitChunk();
                        if (c == null) continue;
                        current = new AABB(c).iterator();
                    }
                    this.current = current;
                    return current != null && current.hasNext();
                }

                @Override
                public Block next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    if (!$assertionsDisabled && this.current == null) {
                        throw new AssertionError();
                    }
                    return this.current.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public String toString() {
            return this.faction.getName();
        }

        @Override
        public Fields serialize() {
            Fields fields = new Fields();
            fields.putObject("universe", this.faction.getUniverse());
            fields.putObject("id", this.faction.getId());
            return fields;
        }

        @Override
        public void deserialize(Fields fields) throws StreamCorruptedException {
            String universe = fields.getObject("universe", String.class);
            String id = fields.getObject("id", String.class);
            Faction f = ((FactionColl)FactionColls.get().getForUniverse(universe)).get((Object)id);
            if (f == null) {
                throw new StreamCorruptedException("Invalid faction " + id + " in universe " + universe);
            }
            this.faction = f;
        }

        @Override
        public RegionsPlugin<?> getPlugin() {
            return Factions2Hook.this;
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!(o instanceof FactionsRegion)) {
                return false;
            }
            return this.faction.equals(((FactionsRegion)o).faction);
        }

        @Override
        public int hashCode() {
            return this.faction.hashCode();
        }
    }
}

