/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.hooks.economy.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.hooks.VaultHook;
import ch.njol.skript.hooks.economy.classes.Money;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Money")
@Description(value={"How much virtual money a player has (can be changed). This expression requires Vault and a compatible economy plugin to be installed."})
@Examples(value={"message \"You have %player's money%\" # the currency name will be added automatically", "remove 20$ from the player's balance # replace '$' by whatever currency you use", "add 200 to the player's account # or omit the currency alltogether"})
@Since(value="2.0")
public class ExprBalance
extends SimplePropertyExpression<OfflinePlayer, Money> {
    static {
        ExprBalance.register(ExprBalance.class, Money.class, "(money|balance|[bank] account)", "players");
    }

    @Override
    public Money convert(OfflinePlayer p) {
        return new Money(VaultHook.economy.getBalance(p.getName()));
    }

    @Override
    public Class<? extends Money> getReturnType() {
        return Money.class;
    }

    @Override
    protected String getPropertyName() {
        return "money";
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.REMOVE_ALL) {
            return null;
        }
        return new Class[]{Money.class, Number.class};
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        assert (mode != Changer.ChangeMode.REMOVE_ALL);
        if (delta == null) {
            OfflinePlayer[] offlinePlayerArray = (OfflinePlayer[])this.getExpr().getArray(e);
            int n = offlinePlayerArray.length;
            int n2 = 0;
            while (n2 < n) {
                OfflinePlayer p = offlinePlayerArray[n2];
                VaultHook.economy.withdrawPlayer(p.getName(), VaultHook.economy.getBalance(p.getName()));
                ++n2;
            }
            return;
        }
        double m = delta[0] instanceof Number ? ((Number)delta[0]).doubleValue() : ((Money)delta[0]).getAmount();
        OfflinePlayer[] offlinePlayerArray = (OfflinePlayer[])this.getExpr().getArray(e);
        int n = offlinePlayerArray.length;
        int n3 = 0;
        while (n3 < n) {
            OfflinePlayer p = offlinePlayerArray[n3];
            switch (mode) {
                case SET: {
                    double b = VaultHook.economy.getBalance(p.getName());
                    if (b < m) {
                        VaultHook.economy.depositPlayer(p.getName(), m - b);
                        break;
                    }
                    if (!(b > m)) break;
                    VaultHook.economy.withdrawPlayer(p.getName(), b - m);
                    break;
                }
                case ADD: {
                    VaultHook.economy.depositPlayer(p.getName(), m);
                    break;
                }
                case REMOVE: {
                    VaultHook.economy.withdrawPlayer(p.getName(), m);
                    break;
                }
                case REMOVE_ALL: 
                case DELETE: 
                case RESET: {
                    assert (false);
                    break;
                }
            }
            ++n3;
        }
    }
}

