/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Checker;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

public class EvtItem
extends SkriptEvent {
    private static final boolean hasConsumeEvent = Skript.classExists("org.bukkit.event.player.PlayerItemConsumeEvent");
    @Nullable
    private Literal<ItemType> types;

    static {
        Skript.registerEvent("Dispense", EvtItem.class, BlockDispenseEvent.class, "dispens(e|ing) [[of] %itemtypes%]").description("Called when a dispenser dispenses an item.").examples("").since("");
        Skript.registerEvent("Item Spawn", EvtItem.class, ItemSpawnEvent.class, "item spawn[ing] [[of] %itemtypes%]").description("Called whenever an item stack is spawned in a world, e.g. as drop of a block or mob, a player throwing items out of his inventory, or a dispenser dispensing an item (not shooting it).").examples("").since("");
        Skript.registerEvent("Drop", EvtItem.class, PlayerDropItemEvent.class, "[player] drop[ing] [[of] %itemtypes%]").description("Called when a player drops an item from his inventory.").examples("").since("");
        Skript.registerEvent("Craft", EvtItem.class, CraftItemEvent.class, "[player] craft[ing] [[of] %itemtypes%]").description("Called when a player crafts an item.").examples("").since("");
        Skript.registerEvent("Pick Up", EvtItem.class, PlayerPickupItemEvent.class, "[player] (pick[ ]up|picking up) [[of] %itemtypes%]").description("Called when a player picks up an item. Please note that the item is still on the ground when this event is called.").examples("").since("");
        if (hasConsumeEvent) {
            Skript.registerEvent("Consume", EvtItem.class, PlayerItemConsumeEvent.class, "[player] ((eat|drink)[ing]|consum(e|ing)) [[of] %itemtypes%]").description("Called when a player is done eating/drinking something, e.g. an apple, bread, meat, milk or a potion.").examples("").since("2.0");
        }
    }

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        this.types = args[0];
        return true;
    }

    @Override
    public boolean check(Event e) {
        ItemStack is;
        if (this.types == null) {
            return true;
        }
        if (e instanceof BlockDispenseEvent) {
            is = ((BlockDispenseEvent)e).getItem();
        } else if (e instanceof ItemSpawnEvent) {
            is = ((ItemSpawnEvent)e).getEntity().getItemStack();
        } else if (e instanceof PlayerDropItemEvent) {
            is = ((PlayerDropItemEvent)e).getItemDrop().getItemStack();
        } else if (e instanceof CraftItemEvent) {
            is = ((CraftItemEvent)e).getRecipe().getResult();
        } else if (e instanceof PlayerPickupItemEvent) {
            is = ((PlayerPickupItemEvent)e).getItem().getItemStack();
        } else if (hasConsumeEvent && e instanceof PlayerItemConsumeEvent) {
            is = ((PlayerItemConsumeEvent)e).getItem();
        } else {
            assert (false);
            return false;
        }
        return this.types.check(e, new Checker<ItemType>(){

            @Override
            public boolean check(ItemType t) {
                return t.isOfType(is);
            }
        });
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "dispense/spawn/drop/craft/pickup/consume/break" + (this.types == null ? "" : " of " + this.types);
    }
}

