/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Comparator;
import ch.njol.skript.classes.data.DefaultComparators;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.Checker;
import org.bukkit.Material;
import org.bukkit.entity.Hanging;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.hanging.HangingEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.painting.PaintingBreakEvent;
import org.bukkit.event.painting.PaintingEvent;
import org.bukkit.event.painting.PaintingPlaceEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.eclipse.jdt.annotation.Nullable;

public class EvtBlock
extends SkriptEvent {
    @Nullable
    private Literal<ItemType> types;
    private boolean mine = false;

    static {
        Skript.registerEvent("Break / Mine", EvtBlock.class, new Class[]{BlockBreakEvent.class, PlayerBucketFillEvent.class, Skript.isRunningMinecraft(1, 4, 3) ? HangingBreakEvent.class : PaintingBreakEvent.class}, "[block] (break[ing]|1\u00a6min(e|ing)) [[of] %itemtypes%]").description("Called when a block is broken by a player. If you use 'on mine', only events where the broken block dropped something will call the trigger.").examples("on mine", "on break of stone", "on mine of any ore").since("1.0 (break), <i>unknown</i> (mine)");
        Skript.registerEvent("Burn", EvtBlock.class, BlockBurnEvent.class, "[block] burn[ing] [[of] %itemtypes%]").description("Called when a block is destroyed by fire.").examples("on burn", "on burn of wood, fences, or chests").since("1.0");
        Skript.registerEvent("Place", EvtBlock.class, new Class[]{BlockPlaceEvent.class, PlayerBucketEmptyEvent.class, Skript.isRunningMinecraft(1, 4, 3) ? HangingPlaceEvent.class : PaintingPlaceEvent.class}, "[block] (plac(e|ing)|build[ing]) [[of] %itemtypes%]").description("Called when a player places a block.").examples("on place", "on place of a furnace, workbench or chest").since("1.0");
        Skript.registerEvent("Fade", EvtBlock.class, BlockFadeEvent.class, "[block] fad(e|ing) [[of] %itemtypes%]").description("Called when a block 'fades away', e.g. ice or snow melts.").examples("on fade of snow or ice").since("1.0");
        Skript.registerEvent("Form", EvtBlock.class, BlockFormEvent.class, "[block] form[ing] [[of] %itemtypes%]").description("Called when a block is created, but not by a player, e.g. snow forms due to snowfall, water freezes in cold biomes, or a block spreads (see <a href='#spread'>spread event</a>).").examples("on form of snow", "on form of a mushroom").since("1.0");
    }

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        this.types = args[0];
        this.mine = parser.mark == 1;
        return true;
    }

    @Override
    public boolean check(Event e) {
        byte durability;
        int id;
        if (this.mine && e instanceof BlockBreakEvent && ((BlockBreakEvent)e).getBlock().getDrops(((BlockBreakEvent)e).getPlayer().getItemInHand()).isEmpty()) {
            return false;
        }
        if (this.types == null) {
            return true;
        }
        if (e instanceof BlockEvent) {
            id = ((BlockEvent)e).getBlock().getTypeId();
            durability = ((BlockEvent)e).getBlock().getData();
        } else if (e instanceof BlockFormEvent) {
            id = ((BlockFormEvent)e).getNewState().getTypeId();
            durability = ((BlockFormEvent)e).getNewState().getRawData();
        } else if (e instanceof PlayerBucketFillEvent) {
            id = ((PlayerBucketEvent)e).getBlockClicked().getRelative(((PlayerBucketEvent)e).getBlockFace()).getTypeId();
            durability = ((PlayerBucketEvent)e).getBlockClicked().getRelative(((PlayerBucketEvent)e).getBlockFace()).getData();
        } else if (e instanceof PlayerBucketEmptyEvent) {
            id = ((PlayerBucketEmptyEvent)e).getBucket() == Material.WATER_BUCKET ? Material.STATIONARY_WATER.getId() : Material.STATIONARY_LAVA.getId();
            durability = 0;
        } else if (e instanceof PaintingEvent) {
            id = Material.PAINTING.getId();
            durability = 0;
        } else {
            if (Skript.isRunningMinecraft(1, 4, 3) && e instanceof HangingEvent) {
                final EntityData<Hanging> d = EntityData.fromEntity(((HangingEvent)e).getEntity());
                return this.types.check(e, new Checker<ItemType>(){

                    @Override
                    public boolean check(@Nullable ItemType t) {
                        return t != null && Comparator.Relation.EQUAL.is(DefaultComparators.entityItemComparator.compare(d, t));
                    }
                });
            }
            assert (false);
            return false;
        }
        return this.types.check(e, new Checker<ItemType>(){

            @Override
            public boolean check(@Nullable ItemType t) {
                return t != null && t.isOfType(id, durability);
            }
        });
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "break/place/burn/fade/form of " + Classes.toString(this.types);
    }
}

