/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Is Holding")
@Description(value={"Checks whether a player is holdign a specific item. Cannot be used with endermen, use 'entity is [not] an enderman holding &lt;item type&gt;' instead."})
@Examples(value={"player is holding a stick", "victim isn't holding a sword of sharpness"})
@Since(value="1.0")
public class CondItemInHand
extends Condition {
    private Expression<LivingEntity> entities;
    Expression<ItemType> types;

    static {
        Skript.registerCondition(CondItemInHand.class, "[%livingentities%] ha(s|ve) %itemtypes% in hand", "[%livingentities%] (is|are) holding %itemtypes%", "[%livingentities%] (ha(s|ve) not|do[es]n't have) %itemtypes% in hand", "[%livingentities%] (is not|isn't) holding %itemtypes%");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.entities = vars[0];
        this.types = vars[1];
        this.setNegated(matchedPattern >= 2);
        return true;
    }

    @Override
    public boolean check(final Event e) {
        return this.entities.check(e, new Checker<LivingEntity>(){

            @Override
            public boolean check(final LivingEntity en) {
                return CondItemInHand.this.types.check(e, new Checker<ItemType>(){

                    @Override
                    public boolean check(ItemType type) {
                        return type.isOfType(en.getEquipment().getItemInHand());
                    }
                }, CondItemInHand.this.isNegated());
            }
        });
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return String.valueOf(this.entities.toString(e, debug)) + " " + (this.entities.isSingle() ? "is" : "are") + " holding " + this.types.toString(e, debug);
    }
}

