/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.Updater;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.command.CommandHelp;
import ch.njol.skript.localization.ArgsMessage;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.PluralizingArgsMessage;
import ch.njol.skript.log.RedirectingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.util.Color;
import ch.njol.skript.util.ExceptionUtils;
import ch.njol.skript.util.FileUtils;
import ch.njol.skript.util.Utils;
import ch.njol.util.StringUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.util.ChatPaginator;
import org.eclipse.jdt.annotation.Nullable;

public class SkriptCommand
implements CommandExecutor {
    private static final String NODE = "skript command";
    private static final CommandHelp skriptCommandHelp = new CommandHelp("<gray>/<gold>skript", Color.LIGHT_CYAN, "skript command.help").add(new CommandHelp("reload", Color.DARK_RED).add("all").add("config").add("aliases").add("scripts").add("<script>")).add(new CommandHelp("enable", Color.DARK_RED).add("all").add("<script>")).add(new CommandHelp("disable", Color.DARK_RED).add("all").add("<script>")).add(new CommandHelp("update", Color.DARK_RED).add("check").add("changes").add("download")).add("help");
    private static final ArgsMessage m_reloading = new ArgsMessage("skript command.reload.reloading");
    private static final ArgsMessage m_reloaded = new ArgsMessage("skript command.reload.reloaded");
    private static final ArgsMessage m_reload_error = new ArgsMessage("skript command.reload.error");
    private static final ArgsMessage m_changes_title = new ArgsMessage("skript command.update.changes.title");
    private static final ArgsMessage m_invalid_script = new ArgsMessage("skript command.invalid script");
    private static final ArgsMessage m_invalid_folder = new ArgsMessage("skript command.invalid folder");

    private static final void reloading(CommandSender sender, String what, Object ... args) {
        what = args.length == 0 ? Language.get("skript command.reload." + what) : Language.format("skript command.reload." + what, args);
        Skript.info(sender, StringUtils.fixCapitalization(m_reloading.toString(what)));
    }

    private static final void reloaded(CommandSender sender, RedirectingLogHandler r, String what, Object ... args) {
        String string = what = args.length == 0 ? Language.get("skript command.reload." + what) : PluralizingArgsMessage.format(Language.format("skript command.reload." + what, args));
        if (r.numErrors() == 0) {
            Skript.info(sender, StringUtils.fixCapitalization(PluralizingArgsMessage.format(m_reloaded.toString(what))));
        } else {
            Skript.error(sender, StringUtils.fixCapitalization(PluralizingArgsMessage.format(m_reload_error.toString(what, r.numErrors()))));
        }
    }

    private static final void info(CommandSender sender, String what, Object ... args) {
        what = args.length == 0 ? Language.get("skript command." + what) : PluralizingArgsMessage.format(Language.format("skript command." + what, args));
        Skript.info(sender, StringUtils.fixCapitalization(what));
    }

    private static final void message(CommandSender sender, String what, Object ... args) {
        what = args.length == 0 ? Language.get("skript command." + what) : PluralizingArgsMessage.format(Language.format("skript command." + what, args));
        Skript.message(sender, StringUtils.fixCapitalization(what));
    }

    private static final void error(CommandSender sender, String what, Object ... args) {
        what = args.length == 0 ? Language.get("skript command." + what) : PluralizingArgsMessage.format(Language.format("skript command." + what, args));
        Skript.error(sender, StringUtils.fixCapitalization(what));
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
    public boolean onCommand(@Nullable CommandSender sender, @Nullable Command command, @Nullable String label, @Nullable String[] args) {
        block114: {
            if (sender == null || command == null || label == null || args == null) {
                throw new IllegalArgumentException();
            }
            if (!skriptCommandHelp.test(sender, args)) {
                return true;
            }
            RedirectingLogHandler r = SkriptLogger.startLogHandler(new RedirectingLogHandler(sender, ""));
            try {
                File f;
                if (args[0].equalsIgnoreCase("reload")) {
                    if (args[1].equalsIgnoreCase("all")) {
                        SkriptCommand.reloading(sender, "config and scripts", new Object[0]);
                        Skript.reload();
                        SkriptCommand.reloaded(sender, r, "config and scripts", new Object[0]);
                    } else if (args[1].equalsIgnoreCase("scripts")) {
                        SkriptCommand.reloading(sender, "scripts", new Object[0]);
                        Skript.reloadScripts();
                        SkriptCommand.reloaded(sender, r, "scripts", new Object[0]);
                    } else if (args[1].equalsIgnoreCase("config")) {
                        SkriptCommand.reloading(sender, "main config", new Object[0]);
                        Skript.reloadMainConfig();
                        SkriptCommand.reloaded(sender, r, "main config", new Object[0]);
                    } else if (args[1].equalsIgnoreCase("aliases")) {
                        SkriptCommand.reloading(sender, "aliases", new Object[0]);
                        Skript.reloadAliases();
                        SkriptCommand.reloaded(sender, r, "aliases", new Object[0]);
                    } else {
                        f = SkriptCommand.getScriptFromArgs(sender, args, 1);
                        if (f == null) {
                            return true;
                        }
                        if (!f.isDirectory()) {
                            if (f.getName().startsWith("-")) {
                                SkriptCommand.info(sender, "reload.script disabled", f.getName().substring(1));
                                return true;
                            }
                            SkriptCommand.reloading(sender, "script", f.getName());
                            ScriptLoader.unloadScript(f);
                            ScriptLoader.loadScripts(new File[]{f});
                            SkriptCommand.reloaded(sender, r, "script", f.getName());
                        } else {
                            SkriptCommand.reloading(sender, "scripts in folder", f.getName());
                            int disabled = ScriptLoader.unloadScripts((File)f).files;
                            int enabled = ScriptLoader.loadScripts((File)f).files;
                            if (Math.max(disabled, enabled) == 0) {
                                SkriptCommand.info(sender, "reload.empty folder", f.getName());
                            } else {
                                SkriptCommand.reloaded(sender, r, "x scripts in folder", f.getName(), Math.max(disabled, enabled));
                            }
                        }
                    }
                    break block114;
                }
                if (args[0].equalsIgnoreCase("enable")) {
                    Collection<File> scripts;
                    if (args[1].equals("all")) {
                        try {
                            SkriptCommand.info(sender, "enable.all.enabling", new Object[0]);
                            File[] files = SkriptCommand.toggleScripts(new File(Skript.getInstance().getDataFolder(), "scripts"), true).toArray(new File[0]);
                            assert (files != null);
                            ScriptLoader.loadScripts(files);
                            if (r.numErrors() == 0) {
                                SkriptCommand.info(sender, "enable.all.enabled", new Object[0]);
                                break block114;
                            }
                            SkriptCommand.error(sender, "enable.all.error", r.numErrors());
                        }
                        catch (IOException e) {
                            SkriptCommand.error(sender, "enable.all.io error", ExceptionUtils.toString(e));
                        }
                        break block114;
                    }
                    f = SkriptCommand.getScriptFromArgs(sender, args, 1);
                    if (f == null) {
                        return true;
                    }
                    if (!f.isDirectory()) {
                        if (!f.getName().startsWith("-")) {
                            SkriptCommand.info(sender, "enable.single.already enabled", f.getName(), StringUtils.join(args, " ", 1, args.length));
                            return true;
                        }
                        try {
                            f = FileUtils.move(f, new File(f.getParentFile(), f.getName().substring(1)), false);
                        }
                        catch (IOException e) {
                            SkriptCommand.error(sender, "enable.single.io error", f.getName().substring(1), ExceptionUtils.toString(e));
                            r.stop();
                            return true;
                        }
                        SkriptCommand.info(sender, "enable.single.enabling", f.getName());
                        ScriptLoader.loadScripts(new File[]{f});
                        if (r.numErrors() == 0) {
                            SkriptCommand.info(sender, "enable.single.enabled", f.getName());
                        } else {
                            SkriptCommand.error(sender, "enable.single.error", f.getName(), r.numErrors());
                        }
                        return true;
                    }
                    try {
                        scripts = SkriptCommand.toggleScripts(f, true);
                    }
                    catch (IOException e) {
                        SkriptCommand.error(sender, "enable.folder.io error", f.getName(), ExceptionUtils.toString(e));
                        r.stop();
                        return true;
                    }
                    if (scripts.isEmpty()) {
                        SkriptCommand.info(sender, "enable.folder.empty", f.getName());
                        return true;
                    }
                    SkriptCommand.info(sender, "enable.folder.enabling", f.getName(), scripts.size());
                    File[] ss = scripts.toArray(new File[scripts.size()]);
                    assert (ss != null);
                    ScriptLoader.ScriptInfo i = ScriptLoader.loadScripts(ss);
                    assert (i.files == scripts.size());
                    if (r.numErrors() == 0) {
                        SkriptCommand.info(sender, "enable.folder.enabled", f.getName(), i.files);
                    } else {
                        SkriptCommand.error(sender, "enable.folder.error", f.getName(), r.numErrors());
                    }
                    return true;
                }
                if (args[0].equalsIgnoreCase("disable")) {
                    Collection<File> scripts;
                    if (args[1].equals("all")) {
                        Skript.disableScripts();
                        try {
                            SkriptCommand.toggleScripts(new File(Skript.getInstance().getDataFolder(), "scripts"), false);
                            SkriptCommand.info(sender, "disable.all.disabled", new Object[0]);
                        }
                        catch (IOException e) {
                            SkriptCommand.error(sender, "disable.all.io error", ExceptionUtils.toString(e));
                        }
                        break block114;
                    }
                    f = SkriptCommand.getScriptFromArgs(sender, args, 1);
                    if (f == null) {
                        return true;
                    }
                    if (!f.isDirectory()) {
                        if (f.getName().startsWith("-")) {
                            SkriptCommand.info(sender, "disable.single.already disabled", f.getName().substring(1));
                            return true;
                        }
                        ScriptLoader.unloadScript(f);
                        try {
                            FileUtils.move(f, new File(f.getParentFile(), "-" + f.getName()), false);
                        }
                        catch (IOException e) {
                            SkriptCommand.error(sender, "disable.single.io error", f.getName(), ExceptionUtils.toString(e));
                            r.stop();
                            return true;
                        }
                        SkriptCommand.info(sender, "disable.single.disabled", f.getName());
                        return true;
                    }
                    try {
                        scripts = SkriptCommand.toggleScripts(f, false);
                    }
                    catch (IOException e) {
                        SkriptCommand.error(sender, "disable.folder.io error", f.getName(), ExceptionUtils.toString(e));
                        r.stop();
                        return true;
                    }
                    if (scripts.isEmpty()) {
                        SkriptCommand.info(sender, "disable.folder.empty", f.getName());
                        return true;
                    }
                    for (File script : scripts) {
                        ScriptLoader.unloadScript(new File(script.getParentFile(), script.getName().substring(1)));
                    }
                    SkriptCommand.info(sender, "disable.folder.disabled", f.getName(), scripts.size());
                    return true;
                }
                try {
                    if (args[0].equalsIgnoreCase("update")) {
                        Updater.stateLock.writeLock().lock();
                        try {
                            Updater.UpdateState state = Updater.state;
                            if (args[1].equals("check")) {
                                switch (state) {
                                    case NOT_STARTED: {
                                        Updater.check(sender, false, false);
                                        break;
                                    }
                                    case CHECK_IN_PROGRESS: {
                                        Skript.info(sender, "" + Updater.m_check_in_progress);
                                        break;
                                    }
                                    case CHECK_ERROR: {
                                        Updater.check(sender, false, false);
                                        break;
                                    }
                                    case CHECKED_FOR_UPDATE: {
                                        if (Updater.latest.get() == null) {
                                            Skript.info(sender, Skript.getVersion().isStable() ? "" + Updater.m_running_latest_version : "" + Updater.m_running_latest_version_beta);
                                            break;
                                        }
                                        Skript.info(sender, "" + Updater.m_update_available);
                                        break;
                                    }
                                    case DOWNLOAD_IN_PROGRESS: {
                                        Skript.info(sender, "" + Updater.m_download_in_progress);
                                        break;
                                    }
                                    case DOWNLOAD_ERROR: {
                                        Skript.info(sender, "" + Updater.m_download_error);
                                        break;
                                    }
                                    case DOWNLOADED: {
                                        Skript.info(sender, "" + Updater.m_downloaded);
                                    }
                                }
                            } else if (args[1].equalsIgnoreCase("changes")) {
                                if (state == Updater.UpdateState.NOT_STARTED) {
                                    Skript.info(sender, "" + Updater.m_not_started);
                                } else if (state == Updater.UpdateState.CHECK_IN_PROGRESS) {
                                    Skript.info(sender, "" + Updater.m_check_in_progress);
                                } else if (state == Updater.UpdateState.CHECK_ERROR) {
                                    Skript.info(sender, "" + Updater.m_check_error);
                                } else if (Updater.latest.get() == null) {
                                    Skript.info(sender, Skript.getVersion().isStable() ? "" + Updater.m_running_latest_version : "" + Updater.m_running_latest_version_beta);
                                } else {
                                    int pageNum = 1;
                                    if (args.length >= 3 && args[2].matches("\\d+")) {
                                        String a2 = args[2];
                                        assert (a2 != null);
                                        pageNum = Utils.parseInt(a2);
                                    }
                                    StringBuilder changes = new StringBuilder();
                                    for (Updater.VersionInfo i : Updater.infos) {
                                        if (changes.length() != 0) {
                                            changes.append("\n");
                                        }
                                        changes.append(String.valueOf(Skript.SKRIPT_PREFIX) + Utils.replaceEnglishChatStyles(m_changes_title.toString(i.version, i.date)));
                                        changes.append("\n");
                                        changes.append(i.changelog);
                                    }
                                    ChatPaginator.ChatPage page = ChatPaginator.paginate((String)changes.toString(), (int)pageNum, (int)55, (int)18);
                                    sender.sendMessage(page.getLines());
                                    if (pageNum < page.getTotalPages()) {
                                        SkriptCommand.message(sender, "update.changes.next page", pageNum, page.getTotalPages(), pageNum + 1);
                                    }
                                }
                            } else if (args[1].equalsIgnoreCase("download")) {
                                switch (state) {
                                    case NOT_STARTED: {
                                        Updater.check(sender, true, false);
                                        break;
                                    }
                                    case CHECK_IN_PROGRESS: {
                                        Skript.info(sender, "" + Updater.m_check_in_progress);
                                        break;
                                    }
                                    case CHECK_ERROR: {
                                        Updater.check(sender, true, false);
                                        break;
                                    }
                                    case CHECKED_FOR_UPDATE: {
                                        if (Updater.latest.get() == null) {
                                            Skript.info(sender, Skript.getVersion().isStable() ? "" + Updater.m_running_latest_version : "" + Updater.m_running_latest_version_beta);
                                            break;
                                        }
                                        Updater.download(sender, false);
                                        break;
                                    }
                                    case DOWNLOAD_IN_PROGRESS: {
                                        Skript.info(sender, "" + Updater.m_download_in_progress);
                                        break;
                                    }
                                    case DOWNLOADED: {
                                        Skript.info(sender, "" + Updater.m_downloaded);
                                        break;
                                    }
                                    case DOWNLOAD_ERROR: {
                                        Updater.download(sender, false);
                                    }
                                    default: {
                                        break;
                                    }
                                }
                            }
                            break block114;
                        }
                        finally {
                            Updater.stateLock.writeLock().unlock();
                        }
                    }
                    if (args[0].equalsIgnoreCase("help")) {
                        skriptCommandHelp.showHelp(sender);
                    }
                }
                catch (Exception e) {
                    Skript.exception((Throwable)e, "Exception occurred in Skript's main command", "Used command: /" + label + " " + StringUtils.join(args, " "));
                }
            }
            finally {
                r.stop();
            }
        }
        return true;
    }

    @Nullable
    private static File getScriptFromArgs(CommandSender sender, String[] args, int start) {
        File f;
        boolean isFolder;
        String script = StringUtils.join(args, " ", start, args.length);
        boolean bl = isFolder = script.endsWith("/") || script.endsWith("\\");
        if (isFolder) {
            script = script.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        } else if (!StringUtils.endsWithIgnoreCase(script, ".sk")) {
            script = String.valueOf(script) + ".sk";
        }
        if (script.startsWith("-")) {
            script = script.substring(1);
        }
        if (!(f = new File(Skript.getInstance().getDataFolder(), "scripts" + File.separator + script)).exists() && !(f = new File(f.getParentFile(), "-" + f.getName())).exists()) {
            Skript.error(sender, (isFolder ? m_invalid_folder : m_invalid_script).toString(script));
            return null;
        }
        return f;
    }

    private static final Collection<File> toggleScripts(File folder, final boolean enable) throws IOException {
        return FileUtils.renameAll(folder, new Converter<String, String>(){

            @Override
            @Nullable
            public String convert(String name) {
                if (StringUtils.endsWithIgnoreCase(name, ".sk") && name.startsWith("-") == enable) {
                    return enable ? name.substring(1) : "-" + name;
                }
                return null;
            }
        });
    }
}

