/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.yggdrasil;

import ch.njol.yggdrasil.Tag;
import ch.njol.yggdrasil.Yggdrasil;
import ch.njol.yggdrasil.YggdrasilException;
import ch.njol.yggdrasil.YggdrasilOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;

public final class DefaultYggdrasilOutputStream
extends YggdrasilOutputStream {
    private final OutputStream out;
    private final short version;
    private final HashMap<String, Integer> writtenShortStrings = new HashMap();
    int nextShortStringID = 0;

    public DefaultYggdrasilOutputStream(Yggdrasil y, OutputStream out) throws IOException {
        super(y);
        this.out = out;
        this.version = y.version;
        this.writeInt(1499948800);
        this.writeShort(this.version);
    }

    private void write(int b) throws IOException {
        this.out.write(b);
    }

    @Override
    protected void writeTag(Tag t) throws IOException {
        this.out.write(t.tag);
    }

    private void writeShortString(String s) throws IOException {
        if (this.writtenShortStrings.containsKey(s)) {
            this.writeTag(Tag.T_REFERENCE);
            if (this.version <= 1) {
                this.writeInt(this.writtenShortStrings.get(s));
            } else {
                this.writeUnsignedInt(this.writtenShortStrings.get(s));
            }
        } else {
            if (this.nextShortStringID < 0) {
                throw new YggdrasilException("Too many field names/class IDs (max: 2147483647)");
            }
            byte[] d = s.getBytes(StandardCharsets.UTF_8);
            if (d.length >= (Tag.T_REFERENCE.tag & 0xFF)) {
                throw new YggdrasilException("Field name or Class ID too long: " + s);
            }
            this.write(d.length);
            this.out.write(d);
            if (d.length > 4) {
                this.writtenShortStrings.put(s, this.nextShortStringID++);
            }
        }
    }

    private void writeByte(byte b) throws IOException {
        this.write(b & 0xFF);
    }

    private void writeShort(short s) throws IOException {
        this.write(s >>> 8 & 0xFF);
        this.write(s & 0xFF);
    }

    private void writeUnsignedShort(short s) throws IOException {
        assert (s >= 0);
        if (s <= 127) {
            this.writeByte((byte)(0x80 | s));
        } else {
            this.writeShort(s);
        }
    }

    private void writeInt(int i) throws IOException {
        this.write(i >>> 24 & 0xFF);
        this.write(i >>> 16 & 0xFF);
        this.write(i >>> 8 & 0xFF);
        this.write(i & 0xFF);
    }

    private void writeUnsignedInt(int i) throws IOException {
        assert (i >= 0);
        if (i <= Short.MAX_VALUE) {
            this.writeShort((short)(0x8000 | i));
        } else {
            this.writeInt(i);
        }
    }

    private void writeLong(long l) throws IOException {
        this.write((int)(l >>> 56 & 0xFFL));
        this.write((int)(l >>> 48 & 0xFFL));
        this.write((int)(l >>> 40 & 0xFFL));
        this.write((int)(l >>> 32 & 0xFFL));
        this.write((int)(l >>> 24 & 0xFFL));
        this.write((int)(l >>> 16 & 0xFFL));
        this.write((int)(l >>> 8 & 0xFFL));
        this.write((int)(l & 0xFFL));
    }

    private void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    private void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    private void writeChar(char c) throws IOException {
        this.writeShort((short)c);
    }

    private void writeBoolean(boolean b) throws IOException {
        this.write(b ? 1 : 0);
    }

    @Override
    protected void writePrimitive_(Object o) throws IOException {
        switch (Tag.getPrimitiveFromWrapper(o.getClass())) {
            case T_BYTE: {
                this.writeByte((Byte)o);
                break;
            }
            case T_SHORT: {
                this.writeShort((Short)o);
                break;
            }
            case T_INT: {
                this.writeInt((Integer)o);
                break;
            }
            case T_LONG: {
                this.writeLong((Long)o);
                break;
            }
            case T_FLOAT: {
                this.writeFloat(((Float)o).floatValue());
                break;
            }
            case T_DOUBLE: {
                this.writeDouble((Double)o);
                break;
            }
            case T_CHAR: {
                this.writeChar(((Character)o).charValue());
                break;
            }
            case T_BOOLEAN: {
                this.writeBoolean((Boolean)o);
                break;
            }
            default: {
                throw new YggdrasilException("Invalid call to writePrimitive with argument " + o);
            }
        }
    }

    @Override
    protected void writePrimitiveValue(Object o) throws IOException {
        this.writePrimitive_(o);
    }

    @Override
    protected void writeStringValue(String s) throws IOException {
        byte[] d = s.getBytes(StandardCharsets.UTF_8);
        this.writeUnsignedInt(d.length);
        this.out.write(d);
    }

    @Override
    protected void writeArrayComponentType(Class<?> componentType) throws IOException {
        this.writeClass_(componentType);
    }

    @Override
    protected void writeArrayLength(int length) throws IOException {
        this.writeUnsignedInt(length);
    }

    @Override
    protected void writeArrayEnd() throws IOException {
    }

    @Override
    protected void writeClassType(Class<?> c) throws IOException {
        this.writeClass_(c);
    }

    private void writeClass_(Class<?> c) throws IOException {
        while (c.isArray()) {
            this.writeTag(Tag.T_ARRAY);
            c = c.getComponentType();
        }
        Tag t = Tag.getType(c);
        switch (t) {
            case T_ENUM: 
            case T_OBJECT: {
                this.writeTag(t);
                this.writeShortString(this.yggdrasil.getID(c));
                break;
            }
            case T_BYTE: 
            case T_SHORT: 
            case T_INT: 
            case T_LONG: 
            case T_FLOAT: 
            case T_DOUBLE: 
            case T_CHAR: 
            case T_BOOLEAN: 
            case T_BYTE_OBJ: 
            case T_SHORT_OBJ: 
            case T_INT_OBJ: 
            case T_LONG_OBJ: 
            case T_FLOAT_OBJ: 
            case T_DOUBLE_OBJ: 
            case T_CHAR_OBJ: 
            case T_BOOLEAN_OBJ: 
            case T_STRING: 
            case T_CLASS: {
                this.writeTag(t);
                break;
            }
            default: {
                throw new YggdrasilException(c.getCanonicalName());
            }
        }
    }

    @Override
    protected void writeEnumType(String type) throws IOException {
        this.writeShortString(type);
    }

    @Override
    protected void writeEnumID(String id) throws IOException {
        this.writeShortString(id);
    }

    @Override
    protected void writeObjectType(String type) throws IOException {
        this.writeShortString(type);
    }

    @Override
    protected void writeNumFields(short numFields) throws IOException {
        this.writeUnsignedShort(numFields);
    }

    @Override
    protected void writeFieldID(String id) throws IOException {
        this.writeShortString(id);
    }

    @Override
    protected void writeObjectEnd() throws IOException {
    }

    @Override
    protected void writeReferenceID(int ref) throws IOException {
        this.writeUnsignedInt(ref);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

