/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.yggdrasil;

import ch.njol.yggdrasil.Tag;
import ch.njol.yggdrasil.Yggdrasil;
import ch.njol.yggdrasil.YggdrasilException;
import ch.njol.yggdrasil.YggdrasilInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public final class DefaultYggdrasilInputStream
extends YggdrasilInputStream {
    private final short version;
    final InputStream in;
    private final List<String> readShortStrings = new ArrayList<String>();

    public DefaultYggdrasilInputStream(Yggdrasil y, InputStream in) throws IOException {
        super(y);
        this.in = in;
        int m = this.readInt();
        if (m != 1499948800) {
            throw new StreamCorruptedException("Not an Yggdrasil stream");
        }
        this.version = this.readShort();
        if (this.version <= 0 || this.version > 1) {
            throw new StreamCorruptedException("Input was saved using a later version of Yggdrasil");
        }
    }

    private int read() throws IOException {
        int b = this.in.read();
        if (b < 0) {
            throw new EOFException();
        }
        return b;
    }

    private void readFully(byte[] buf) throws IOException {
        this.readFully(buf, 0, buf.length);
    }

    private void readFully(byte[] buf, int off, int len) throws IOException {
        int l = len;
        while (l > 0) {
            int n = this.in.read(buf, off, l);
            if (n < 0) {
                throw new EOFException("Expected " + len + " bytes, but could only read " + (len - l));
            }
            off += n;
            l -= n;
        }
    }

    private String readShortString() throws IOException {
        int length = this.read();
        if (length == (Tag.T_REFERENCE.tag & 0xFF)) {
            int i;
            int n = i = this.version <= 1 ? this.readInt() : this.readUnsignedInt();
            if (i < 0 || i > this.readShortStrings.size()) {
                throw new StreamCorruptedException("Invalid short string reference " + i);
            }
            return this.readShortStrings.get(i);
        }
        byte[] d = new byte[length];
        this.readFully(d);
        String s = new String(d, StandardCharsets.UTF_8);
        if (length > 4) {
            this.readShortStrings.add(s);
        }
        return s;
    }

    @Override
    protected Tag readTag() throws IOException {
        int t = this.read();
        Tag tag = Tag.byID(t);
        if (tag == null) {
            throw new StreamCorruptedException("Invalid tag 0x" + Integer.toHexString(t));
        }
        return tag;
    }

    private byte readByte() throws IOException {
        return (byte)this.read();
    }

    private short readShort() throws IOException {
        return (short)(this.read() << 8 | this.read());
    }

    private short readUnsignedShort() throws IOException {
        int b = this.read();
        if ((b & 0x80) != 0) {
            return (short)(b & 0xFFFFFF7F);
        }
        return (short)(b << 8 | this.read());
    }

    private int readInt() throws IOException {
        return this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read();
    }

    private int readUnsignedInt() throws IOException {
        int b = this.read();
        if ((b & 0x80) != 0) {
            return (b & 0xFFFFFF7F) << 8 | this.read();
        }
        return b << 24 | this.read() << 16 | this.read() << 8 | this.read();
    }

    private long readLong() throws IOException {
        return (long)this.read() << 56 | (long)this.read() << 48 | (long)this.read() << 40 | (long)this.read() << 32 | (long)this.read() << 24 | (long)(this.read() << 16) | (long)(this.read() << 8) | (long)this.read();
    }

    private float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    private double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    private char readChar() throws IOException {
        return (char)this.readShort();
    }

    private boolean readBoolean() throws IOException {
        int r = this.read();
        if (r == 0) {
            return false;
        }
        if (r == 1) {
            return true;
        }
        throw new StreamCorruptedException("Invalid boolean value " + r);
    }

    @Override
    protected Object readPrimitive(Tag type) throws IOException {
        switch (type) {
            case T_BYTE: {
                return this.readByte();
            }
            case T_SHORT: {
                return this.readShort();
            }
            case T_INT: {
                return this.readInt();
            }
            case T_LONG: {
                return this.readLong();
            }
            case T_FLOAT: {
                return Float.valueOf(this.readFloat());
            }
            case T_DOUBLE: {
                return this.readDouble();
            }
            case T_CHAR: {
                return Character.valueOf(this.readChar());
            }
            case T_BOOLEAN: {
                return this.readBoolean();
            }
        }
        throw new YggdrasilException("Internal error; " + (Object)((Object)type));
    }

    @Override
    protected Object readPrimitive_(Tag type) throws IOException {
        return this.readPrimitive(type);
    }

    @Override
    protected String readString() throws IOException {
        int length = this.readUnsignedInt();
        byte[] d = new byte[length];
        this.readFully(d);
        return new String(d, StandardCharsets.UTF_8);
    }

    @Override
    protected Class<?> readArrayComponentType() throws IOException {
        return this.readClass();
    }

    @Override
    protected int readArrayLength() throws IOException {
        return this.readUnsignedInt();
    }

    @Override
    protected Class<?> readEnumType() throws IOException {
        return this.yggdrasil.getClass(this.readShortString());
    }

    @Override
    protected String readEnumID() throws IOException {
        return this.readShortString();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected Class<?> readClass() throws IOException {
        dim = 0;
        while ((type = this.readTag()) == Tag.T_ARRAY) {
            ++dim;
        }
        switch (DefaultYggdrasilInputStream.$SWITCH_TABLE$ch$njol$yggdrasil$Tag()[type.ordinal()]) {
            case 20: 
            case 22: {
                c = this.yggdrasil.getClass(this.readShortString());
                ** GOTO lbl19
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: {
                c = type.c;
                if (!DefaultYggdrasilInputStream.$assertionsDisabled && c == null) {
                    throw new AssertionError();
                }
                ** GOTO lbl19
            }
            case 1: 
            case 23: {
                throw new StreamCorruptedException("unexpected tag " + (Object)type);
            }
            default: {
                throw new YggdrasilException("Internal error; " + (Object)type);
            }
        }
lbl-1000:
        // 1 sources

        {
            c = Array.newInstance(c, 0).getClass();
lbl19:
            // 3 sources

            ** while (dim-- > 0)
        }
lbl20:
        // 1 sources

        return c;
    }

    @Override
    protected int readReference() throws IOException {
        return this.readUnsignedInt();
    }

    @Override
    protected Class<?> readObjectType() throws IOException {
        return this.yggdrasil.getClass(this.readShortString());
    }

    @Override
    protected short readNumFields() throws IOException {
        return this.readUnsignedShort();
    }

    @Override
    protected String readFieldID() throws IOException {
        return this.readShortString();
    }

    @Override
    public void close() throws IOException {
        try {
            try {
                this.read();
                throw new StreamCorruptedException("Stream still has data, at least " + (1 + this.in.available()) + " bytes remain");
            }
            catch (EOFException eOFException) {
                this.in.close();
            }
        }
        catch (Throwable throwable) {
            this.in.close();
            throw throwable;
        }
    }
}

