/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.TriggerSection;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public class Conditional
extends TriggerSection {
    private final Condition cond;
    @Nullable
    private TriggerSection elseClause = null;

    public Conditional(Condition cond, SectionNode node) {
        super(node);
        this.cond = cond;
    }

    @Override
    @Nullable
    protected TriggerItem walk(Event e) {
        if (this.cond.run(e)) {
            return this.walk(e, true);
        }
        this.debug(e, false);
        if (this.elseClause != null) {
            return this.elseClause;
        }
        return this.getNext();
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return this.cond.toString(e, debug);
    }

    public void loadElseClause(SectionNode node) {
        if (this.elseClause != null) {
            if (this.elseClause instanceof Conditional) {
                ((Conditional)this.elseClause).loadElseClause(node);
            } else {
                Skript.error("There can be only one 'else' section after an 'if' section. Maybe 'else if' is what you meant?");
            }
            return;
        }
        this.elseClause = new TriggerSection(node){

            @Override
            @Nullable
            public TriggerItem walk(Event e) {
                return this.walk(e, true);
            }

            @Override
            public String toString(@Nullable Event e, boolean debug) {
                return "else";
            }
        }.setParent(this.getParent()).setNext(this.getNext());
    }

    public void loadElseIf(Condition cond, SectionNode n) {
        assert (this.elseClause == null || this.elseClause instanceof Conditional);
        if (this.elseClause != null) {
            ((Conditional)this.elseClause).loadElseIf(cond, n);
            return;
        }
        this.elseClause = new Conditional(cond, n).setParent(this.getParent()).setNext(this.getNext());
    }

    public boolean hasElseClause() {
        return this.elseClause != null && !(this.elseClause instanceof Conditional);
    }

    @Override
    public Conditional setNext(@Nullable TriggerItem next) {
        super.setNext(next);
        if (this.elseClause != null) {
            this.elseClause.setNext(next);
        }
        return this;
    }

    @Override
    public Conditional setParent(@Nullable TriggerSection parent) {
        super.setParent(parent);
        if (this.elseClause != null) {
            this.elseClause.setParent(parent);
        }
        return this;
    }
}

