/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.HashSet;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="All Permissions")
@Description(value={"Returns all permissions of the defined player(s). Note that the modifications to resulting list do not actually change permissions."})
@Examples(value={"set {_permissions::*} to all permissions of the player"})
@Since(value="2.2-dev33")
public class ExprPermissions
extends PropertyExpression<Player, String> {
    static {
        ExprPermissions.register(ExprPermissions.class, String.class, "permissions", "players");
    }

    @Override
    public Class<String> getReturnType() {
        return String.class;
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        return true;
    }

    protected String[] get(Event event, Player[] source) {
        HashSet<String> permissions = new HashSet<String>();
        Player[] playerArray = source;
        int n = source.length;
        int n2 = 0;
        while (n2 < n) {
            Player player = playerArray[n2];
            for (PermissionAttachmentInfo permission : player.getEffectivePermissions()) {
                permissions.add(permission.getPermission());
            }
            ++n2;
        }
        return permissions.toArray(new String[permissions.size()]);
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        return "permissions " + (this.getExpr().isDefault() ? "" : " of " + this.getExpr().toString(event, debug));
    }
}

