/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.registrations.Converters;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.meta.ItemMeta;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Named Item/Inventory")
@Description(value={"Directly names an item/inventory, useful for defining a named item/inventory in a script. If you want to (re)name existing items/inventories you can either use this expression or use <code>set <a href='#ExprName'>name of &lt;item/inventory&gt;</a> to &lt;text&gt;</code>."})
@Examples(value={"give a diamond sword of sharpness 100 named \"<gold>Excalibur\" to the player", "set tool of player to the player's tool named \"<gold>Wand\"", "set the name of the player's tool to \"<gold>Wand\"", "open hopper inventory named \"Magic Hopper\" to player"})
@Since(value="2.0, 2.2-dev34 (inventories)")
public class ExprNamed<T>
extends SimpleExpression<T> {
    @Nullable
    private ExprNamed<?> source;
    private Class<T> superType;
    @Nullable
    private Expression<Object> toName;
    @Nullable
    private Expression<String> name;

    static {
        Skript.registerExpression(ExprNamed.class, Object.class, ExpressionType.PROPERTY, "%itemtype/inventorytype% (named|with name) %string%");
    }

    public ExprNamed() {
        this(null, Object.class);
    }

    private ExprNamed(ExprNamed<?> source, Class<? extends T> ... types) {
        this.source = source;
        if (source != null) {
            this.toName = source.toName;
            this.name = source.name;
        }
        this.superType = Utils.getSuperType(types);
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.toName = exprs[0];
        this.name = exprs[1];
        return true;
    }

    @Override
    @Nullable
    protected T[] get(Event e) {
        String name = this.name.getSingle(e);
        Object toName = this.toName.getSingle(e);
        if (name == null || toName == null) {
            return null;
        }
        try {
            return Converters.convertStrictly(new Object[]{this.name(toName, name)}, this.superType);
        }
        catch (ClassCastException e1) {
            return null;
        }
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Nullable
    public Object name(Object o, String name) {
        if (o instanceof InventoryType) {
            return Bukkit.createInventory(null, (InventoryType)((InventoryType)o), (String)name);
        }
        if (o instanceof ItemType) {
            ItemType item = (ItemType)o;
            ItemMeta meta = (ItemMeta)item.getItemMeta();
            if (meta == null) {
                meta = Bukkit.getItemFactory().getItemMeta(Material.STONE);
            }
            meta.setDisplayName(name);
            item.setItemMeta(meta);
            return item;
        }
        return null;
    }

    @Override
    public ExprNamed<?> getSource() {
        return this.source == null ? this : this.source;
    }

    @Override
    public <R> Expression<? extends R> getConvertedExpression(Class<R> ... to) {
        return new ExprNamed<R>(this, to);
    }

    @Override
    public Class<? extends T> getReturnType() {
        return this.superType;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return String.format("%s named %s", this.toName.toString(e, debug), this.name.toString(e, debug));
    }
}

