/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.LiteralUtils;
import ch.njol.util.Kleenean;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Join & Split")
@Description(value={"Joins several texts with a common delimiter (e.g. \", \"), or splits a text into multiple texts at a given delimiter."})
@Examples(value={"message \"Online players: %join all players with \" | \"%\" # %all players% would use the default \"x, y, and z\"", "set {_s::} to the string argument split at \",\""})
@Since(value="2.1")
public class ExprJoinSplit
extends SimpleExpression<String> {
    private boolean join;
    private Expression<String> things;
    @Nullable
    private Expression<String> delimiter;

    static {
        Skript.registerExpression(ExprJoinSplit.class, String.class, ExpressionType.COMBINED, "(concat[enate]|join) %objects% [(with|using|by) [[the] delimiter] %-string%]", "split %string% (at|using|by) [[the] delimiter] %string%", "%string% split (at|using|by) [[the] delimiter] %string%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.join = matchedPattern == 0;
        this.things = LiteralUtils.defendExpression(exprs[0]);
        this.delimiter = exprs[1];
        return LiteralUtils.canInitSafely(this.things);
    }

    @Nullable
    protected String[] get(Event e) {
        String d;
        String[] t = this.things.getArray(e);
        String string = d = this.delimiter != null ? this.delimiter.getSingle(e) : "";
        if (t.length == 0 || d == null) {
            return new String[0];
        }
        if (this.join) {
            StringJoiner joiner = new StringJoiner(d);
            String[] stringArray = t;
            int n = t.length;
            int n2 = 0;
            while (n2 < n) {
                String thing = stringArray[n2];
                joiner.add(Classes.toString(thing));
                ++n2;
            }
            return new String[]{joiner.toString()};
        }
        return t[0].split(Pattern.quote(d), -1);
    }

    @Override
    public boolean isSingle() {
        return this.join;
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return this.join ? "join " + this.things.toString(e, debug) + (this.delimiter != null ? " with " + this.delimiter.toString(e, debug) : "") : "split " + this.things.toString(e, debug) + (this.delimiter != null ? " at " + this.delimiter.toString(e, debug) : "");
    }
}

