/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Flight Mode")
@Description(value={"Whether the player(s) are allowed to fly. Use <a href=effects.html#EffMakeFly>Make Fly</a> effect to force player(s) to fly."})
@Examples(value={"set flight mode of player to true", "send \"%flying state of all players%\""})
@Since(value="2.2-dev34")
public class ExprFlightMode
extends SimplePropertyExpression<Player, Boolean> {
    static {
        ExprFlightMode.register(ExprFlightMode.class, Boolean.class, "fl(y[ing]|ight) (mode|state)", "players");
    }

    @Override
    public Class<Boolean> getReturnType() {
        return Boolean.class;
    }

    @Override
    protected String getPropertyName() {
        return "fl(y[ing]|ight) (mode|state)";
    }

    @Override
    public Boolean convert(Player player) {
        return player.getAllowFlight();
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET) {
            return CollectionUtils.array(Boolean.class);
        }
        return null;
    }

    @Override
    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        boolean state = mode == Changer.ChangeMode.RESET || delta == null ? false : (Boolean)delta[0];
        Player[] playerArray = (Player[])this.getExpr().getArray(event);
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player player = playerArray[n2];
            player.setAllowFlight(state);
            ++n2;
        }
    }
}

