/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.classes.Arithmetic;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.Arrays;
import java.util.function.Function;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Furnace;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Burn/Cook Time")
@Description(value={"The time a furnace takes to burn an item in a <a href='events.html#fuel_burn'>fuel burn</a> event.", "Can also be used to change the burn/cook time of a placed furnace."})
@Examples(value={"on fuel burn:", "\tif fuel slot is coal:", "\t\tset burning time to 1 tick"})
@Since(value="2.2-dev37")
public class ExprBurnCookTime
extends PropertyExpression<Block, Timespan> {
    private boolean cookTime;
    private boolean isEvent;

    static {
        Skript.registerExpression(ExprBurnCookTime.class, Timespan.class, ExpressionType.PROPERTY, "[the] burn[ing] time", "[the] (burn|1\u00a6cook)[ing] time of %blocks%", "%blocks%'[s] (burn|1\u00a6cook)[ing] time");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.cookTime = parseResult.mark == 1;
        boolean bl = this.isEvent = matchedPattern == 0;
        if (this.isEvent && !ScriptLoader.isCurrentEvent(FurnaceBurnEvent.class)) {
            Skript.error("Cannot use 'burning time' outside a fuel burn event.");
            return false;
        }
        if (!this.isEvent) {
            this.setExpr(exprs[0]);
        }
        return true;
    }

    protected Timespan[] get(Event e, Block[] source) {
        if (this.isEvent) {
            return CollectionUtils.array(Timespan.fromTicks_i(((FurnaceBurnEvent)e).getBurnTime()));
        }
        return (Timespan[])Arrays.stream(source).filter(block -> block.getType() == Material.FURNACE || block.getType() == Material.BURNING_FURNACE).map(furnace -> {
            Furnace state = (Furnace)furnace.getState();
            return Timespan.fromTicks_i(this.cookTime ? state.getCookTime() : state.getBurnTime());
        }).toArray(Timespan[]::new);
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return this.isEvent ? "the burning time" : String.format("the %sing time of %s", this.cookTime ? "cook" : "burn", this.getExpr().toString(e, debug));
    }

    @Override
    public Class<? extends Timespan> getReturnType() {
        return Timespan.class;
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.SET) {
            return CollectionUtils.array(Timespan.class);
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta == null) {
            return;
        }
        Function<Timespan, Timespan> value = null;
        ClassInfo<Timespan> ci = Classes.getExactClassInfo(Timespan.class);
        assert (ci != null);
        Arithmetic arithmetic = ci.getRelativeMath();
        Timespan changed = (Timespan)delta[0];
        assert (arithmetic != null);
        switch (mode) {
            case ADD: {
                value = original -> arithmetic.add((Timespan)original, changed);
                break;
            }
            case REMOVE: {
                value = original -> (Timespan)arithmetic.difference((Timespan)original, changed);
                break;
            }
            case SET: {
                value = original -> changed;
            }
        }
        assert (value != null);
        if (this.isEvent) {
            FurnaceBurnEvent event = (FurnaceBurnEvent)e;
            event.setBurnTime(value.apply(Timespan.fromTicks_i(event.getBurnTime())).getTicks());
            return;
        }
        Block[] blockArray = (Block[])this.getExpr().getArray(e);
        int n = blockArray.length;
        int n2 = 0;
        while (n2 < n) {
            Block block = blockArray[n2];
            if (block.getType() == Material.FURNACE && block.getType() == Material.BURNING_FURNACE) {
                Furnace furnace = (Furnace)block.getState();
                long time = value.apply(Timespan.fromTicks_i(this.cookTime ? furnace.getCookTime() : furnace.getBurnTime())).getTicks_i();
                if (this.cookTime) {
                    furnace.setCookTime((short)time);
                } else {
                    furnace.setBurnTime((short)time);
                }
                furnace.update();
            }
            ++n2;
        }
    }
}

