/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import org.bukkit.entity.Rabbit;

public class RabbitData
extends EntityData<Rabbit> {
    private int type = 0;

    static {
        if (Skript.classExists("org.bukkit.entity.Rabbit")) {
            EntityData.register(RabbitData.class, "rabbit", Rabbit.class, 0, "rabbit", "black rabbit", "black and white rabbit", "brown rabbit", "gold rabbit", "salt and pepper rabbit", "killer rabbit", "white rabbit");
        }
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.type = matchedPattern;
        return true;
    }

    @Override
    protected boolean init(Class<? extends Rabbit> c, Rabbit rabbit) {
        this.type = rabbit == null ? 0 : RabbitData.intFromType(rabbit.getRabbitType());
        return true;
    }

    @Override
    public void set(Rabbit entity) {
        if (this.type != 0) {
            entity.setRabbitType(RabbitData.typeFromInt(this.type));
        }
    }

    @Override
    protected boolean match(Rabbit entity) {
        return this.type == 0 || RabbitData.intFromType(entity.getRabbitType()) == this.type;
    }

    @Override
    public Class<? extends Rabbit> getType() {
        return Rabbit.class;
    }

    @Override
    public EntityData getSuperType() {
        return new RabbitData();
    }

    @Override
    protected int hashCode_i() {
        return this.type;
    }

    @Override
    protected boolean equals_i(EntityData<?> obj) {
        if (!(obj instanceof RabbitData)) {
            return false;
        }
        RabbitData other = (RabbitData)obj;
        return this.type == other.type;
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> e) {
        return e instanceof RabbitData && (this.type == 0 || ((RabbitData)e).type == this.type);
    }

    private static Rabbit.Type typeFromInt(int i) {
        switch (i) {
            case 1: {
                return Rabbit.Type.BLACK;
            }
            case 2: {
                return Rabbit.Type.BLACK_AND_WHITE;
            }
            case 3: {
                return Rabbit.Type.BROWN;
            }
            case 4: {
                return Rabbit.Type.GOLD;
            }
            case 5: {
                return Rabbit.Type.SALT_AND_PEPPER;
            }
            case 6: {
                return Rabbit.Type.THE_KILLER_BUNNY;
            }
            case 7: {
                return Rabbit.Type.WHITE;
            }
        }
        return Rabbit.Type.BLACK;
    }

    private static int intFromType(Rabbit.Type type) {
        int i = 0;
        switch (type) {
            case BLACK: {
                i = 1;
                break;
            }
            case BLACK_AND_WHITE: {
                i = 2;
                break;
            }
            case BROWN: {
                i = 3;
                break;
            }
            case GOLD: {
                i = 4;
                break;
            }
            case SALT_AND_PEPPER: {
                i = 5;
                break;
            }
            case THE_KILLER_BUNNY: {
                i = 6;
                break;
            }
            case WHITE: {
                i = 7;
                break;
            }
        }
        return i;
    }
}

