/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import java.util.Random;
import org.bukkit.TreeSpecies;
import org.bukkit.entity.Boat;
import org.eclipse.jdt.annotation.Nullable;

public class BoatData
extends EntityData<Boat> {
    static {
        if (Skript.methodExists(Boat.class, "getWoodType", new Class[0])) {
            EntityData.register(BoatData.class, "boat", Boat.class, 0, "boat", "any boat", "oak boat", "spruce boat", "birch boat", "jungle boat", "acacia boat", "dark oak boat");
        }
    }

    public BoatData() {
        this(0);
    }

    public BoatData(@Nullable TreeSpecies type) {
        this(type != null ? type.ordinal() + 2 : 1);
    }

    private BoatData(int type) {
        this.matchedPattern = type;
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        return true;
    }

    @Override
    protected boolean init(@Nullable Class<? extends Boat> c, @Nullable Boat e) {
        if (e != null) {
            this.matchedPattern = 2 + e.getWoodType().ordinal();
        }
        return true;
    }

    @Override
    public void set(Boat entity) {
        if (this.matchedPattern == 1) {
            this.matchedPattern += new Random().nextInt(TreeSpecies.values().length);
        }
        if (this.matchedPattern > 1) {
            entity.setWoodType(TreeSpecies.values()[this.matchedPattern - 2]);
        }
    }

    @Override
    protected boolean match(Boat entity) {
        return this.matchedPattern <= 1 || entity.getWoodType().ordinal() == this.matchedPattern - 2;
    }

    @Override
    public Class<? extends Boat> getType() {
        return Boat.class;
    }

    @Override
    public EntityData getSuperType() {
        return new BoatData(this.matchedPattern);
    }

    @Override
    protected int hashCode_i() {
        return this.matchedPattern <= 1 ? 0 : this.matchedPattern;
    }

    @Override
    protected boolean equals_i(EntityData<?> obj) {
        if (obj instanceof BoatData) {
            return this.matchedPattern == ((BoatData)obj).matchedPattern;
        }
        return false;
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> e) {
        if (e instanceof BoatData) {
            return this.matchedPattern <= 1 || this.matchedPattern == ((BoatData)e).matchedPattern;
        }
        return false;
    }

    public boolean isOfItemType(ItemType i) {
        if (i.getRandom() == null) {
            return false;
        }
        int ordinal = -1;
        switch (i.getRandom().getType()) {
            case BOAT: {
                ordinal = 0;
                break;
            }
            case BOAT_SPRUCE: {
                ordinal = TreeSpecies.REDWOOD.ordinal();
                break;
            }
            case BOAT_BIRCH: {
                ordinal = TreeSpecies.BIRCH.ordinal();
                break;
            }
            case BOAT_JUNGLE: {
                ordinal = TreeSpecies.JUNGLE.ordinal();
                break;
            }
            case BOAT_ACACIA: {
                ordinal = TreeSpecies.ACACIA.ordinal();
                break;
            }
            case BOAT_DARK_OAK: {
                ordinal = TreeSpecies.DARK_OAK.ordinal();
                break;
            }
            default: {
                return false;
            }
        }
        return this.hashCode_i() == ordinal + 2 || this.matchedPattern + ordinal == 2 || ordinal == 0;
    }
}

