/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Send Block Change")
@Description(value={"Makes a player see a block as something it really isn't"})
@Examples(value={"make player see block at player as dirt"})
@Since(value="2.2-dev37")
public class EffSendBlockChange
extends Effect {
    private static final boolean SUPPORTED = Skript.methodExists(Player.class, "sendBlockChange", Location.class, Material.class, Byte.TYPE);
    private Expression<Player> players;
    private Expression<Block> blocks;
    private Expression<ItemType> as;

    static {
        Skript.registerEffect(EffSendBlockChange.class, "make %players% see %blocks% as %itemtype%");
    }

    @Override
    protected void execute(Event e) {
        ItemType type = this.as.getSingle(e);
        if (type == null) {
            return;
        }
        ItemStack as = type.getRandom();
        if (as == null) {
            return;
        }
        Player[] playerArray = this.players.getArray(e);
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player player = playerArray[n2];
            Block[] blockArray = this.blocks.getArray(e);
            int n3 = blockArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Block block = blockArray[n4];
                player.sendBlockChange(block.getLocation(), as.getType(), (byte)as.getDurability());
                ++n4;
            }
            ++n2;
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return String.format("make %s see %s as %s", this.players.toString(e, debug), this.blocks.toString(e, debug), this.as.toString(e, debug));
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!SUPPORTED) {
            Skript.error("The send block change effect is not supported on this version. If Spigot has added a replacement method without magic values please open an issue at https://github.com/SkriptLang/Skript/issues and support will be added for it.");
            return false;
        }
        this.players = exprs[0];
        this.blocks = exprs[1];
        this.as = exprs[2];
        return true;
    }
}

