/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Loop;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.util.Kleenean;
import java.util.List;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Continue")
@Description(value={"Skips the value currently being looped, moving on to the next value if it exists."})
@Examples(value={"loop all players:\n\tif loop-value does not have permission \"moderator\":\n\t\tcontinue # filter out non moderators\n\tbroadcast \"%loop-player% is a moderator!\" # only moderators get broadcast"})
@Since(value="2.2-dev37")
public class EffContinue
extends Effect {
    private Loop loop;

    static {
        Skript.registerEffect(EffContinue.class, "continue [loop]");
    }

    @Override
    protected void execute(Event e) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    protected TriggerItem walk(Event e) {
        TriggerItem.walk(this.loop, e);
        return null;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "continue";
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        List<Loop> loops = ScriptLoader.currentLoops;
        if (loops.isEmpty()) {
            Skript.error("Continue may only be used in loops");
            return false;
        }
        this.loop = loops.get(loops.size() - 1);
        return true;
    }
}

