/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Starts/Ends With")
@Description(value={"Checks if a text starts or ends with another."})
@Examples(value={"if the argument starts with \"test\":", "\tsend \"Stop!\""})
@Since(value="2.2-dev36")
public class CondStartsWith
extends Condition {
    private Expression<String> strings;
    private Expression<String> prefix;
    private boolean ends;

    static {
        Skript.registerCondition(CondStartsWith.class, "%strings% (start|1\u00a6end)[s] with %string%", "%strings% do[es](n't| not) (start|1\u00a6end) with %string%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.strings = exprs[0];
        this.prefix = exprs[1];
        this.ends = parseResult.mark == 1;
        this.setNegated(matchedPattern == 1);
        return true;
    }

    @Override
    public boolean check(Event e) {
        final String p = this.prefix.getSingle(e);
        if (p == null) {
            return false;
        }
        return this.strings.check(e, new Checker<String>(){

            @Override
            public boolean check(String s) {
                return CondStartsWith.this.ends ? s.startsWith(p) : s.endsWith(p);
            }
        }, this.isNegated());
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return String.valueOf(this.strings.toString(e, debug)) + (this.isNegated() ? " don't " : " ") + (this.ends ? "start" : "end") + " with " + this.prefix.toString(e, debug);
    }
}

