/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.bukkitutil;

import ch.njol.skript.Skript;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.projectiles.ProjectileSource;
import org.eclipse.jdt.annotation.Nullable;

public abstract class ProjectileUtils {
    private static Method getShooter;
    private static Method setShooter;

    static {
        try {
            getShooter = Projectile.class.getMethod("getShooter", new Class[0]);
            try {
                setShooter = Projectile.class.getMethod("setShooter", ProjectileSource.class);
            }
            catch (NoClassDefFoundError e) {
                setShooter = Projectile.class.getMethod("setShooter", LivingEntity.class);
            }
        }
        catch (NoSuchMethodException e) {
            Skript.outdatedError(e);
        }
        catch (SecurityException e) {
            Skript.exception((Throwable)e, "security manager present");
        }
    }

    private ProjectileUtils() {
    }

    @Nullable
    public static Object getShooter(@Nullable Projectile p) {
        if (p == null) {
            return null;
        }
        try {
            return getShooter.invoke((Object)p, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            assert (false);
            return null;
        }
        catch (InvocationTargetException e) {
            Skript.exception((Throwable)e, new String[0]);
            return null;
        }
    }

    public static void setShooter(Projectile p, @Nullable Object shooter) {
        try {
            setShooter.invoke((Object)p, shooter);
        }
        catch (IllegalAccessException e) {
            assert (false);
        }
        catch (IllegalArgumentException e) {
            Skript.exception((Throwable)e, "invalid parameter passed to (" + p + ").setShooter: " + shooter);
        }
        catch (InvocationTargetException e) {
            Skript.exception((Throwable)e, new String[0]);
        }
    }
}

