/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.ExpressionType;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Vectors - Length")
@Description(value={"Gets or sets the length of a vector"})
@Examples(value={"send \"%standard length of vector 1, 2, 3%\"", "set {_v} to vector 1, 2, 3", "set standard length of {_v} to 2", "send \"%standard length of {_v}%\""})
@Since(value="2.2-dev28")
public class ExprVectorLength
extends SimplePropertyExpression<Vector, Double> {
    static {
        Skript.registerExpression(ExprVectorLength.class, Double.class, ExpressionType.PROPERTY, "(vector|standard|normal) length of %vector%", "%vector%['s] (vector|standard|normal) length");
    }

    @Override
    public Double convert(Vector vector) {
        if (vector == null) {
            return null;
        }
        return vector.length();
    }

    @Override
    protected String getPropertyName() {
        return "length of vector";
    }

    @Override
    public Class<? extends Double> getReturnType() {
        return Double.class;
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.SET) {
            return new Class[]{Number.class};
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        assert (delta != null);
        Vector v = (Vector)this.getExpr().getSingle(e);
        if (v == null) {
            return;
        }
        double n = ((Number)delta[0]).doubleValue();
        switch (mode) {
            case REMOVE: {
                n = -n;
            }
            case ADD: {
                if (n < 0.0 && v.lengthSquared() < n * n) {
                    v.zero();
                } else {
                    double l = n + v.length();
                    v.normalize().multiply(l);
                }
                this.getExpr().change(e, new Vector[]{v}, Changer.ChangeMode.SET);
                break;
            }
            case SET: {
                if (n < 0.0) {
                    v.zero();
                } else {
                    v.normalize().multiply(n);
                }
                this.getExpr().change(e, new Vector[]{v}, Changer.ChangeMode.SET);
                break;
            }
            case REMOVE_ALL: 
            case DELETE: 
            case RESET: {
                assert (false);
                break;
            }
        }
    }
}

