/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.WeatherType;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Player Weather")
@Description(value={"The weather for a player."})
@Examples(value={"set weather of arg-player to rainy", "reset player's weather", "if arg-player's weather is rainy"})
@Since(value="2.2-dev34")
public class ExprPlayerWeather
extends SimplePropertyExpression<Player, WeatherType> {
    static {
        ExprPlayerWeather.register(ExprPlayerWeather.class, WeatherType.class, "weather", "players");
    }

    @Override
    protected String getPropertyName() {
        return "weather";
    }

    @Override
    public WeatherType convert(Player player) {
        return WeatherType.fromPlayer(player);
    }

    @Override
    public Class<WeatherType> getReturnType() {
        return WeatherType.class;
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.SET) {
            return CollectionUtils.array(WeatherType.class);
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        WeatherType type = delta == null ? WeatherType.CLEAR : (WeatherType)((Object)delta[0]);
        Player[] playerArray = (Player[])this.getExpr().getArray(e);
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player p = playerArray[n2];
            type.setWeather(p);
            ++n2;
        }
    }
}

