/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Events;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.Math2;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Level Progress")
@Description(value={"The progress a player has made until the next level. Remember that this value is between 0 and 1, not 0 and 100!", "Changing this value can cause a player's level to change if the resulting level progess is negative or larger than 1, e.g.<code>increase the player's level progress by 0.5</code> will make the player gain a level if his progress was more than 50%."})
@Examples(value={"# use the exp bar as mana", "on rightclick with a blaze rod:", "\tplayer's level progress is larger than 0.2", "\tshoot a fireball from the player", "\treduce the player's level progress by 0.2", "every 2 seconds:", "\tloop all players:", "\t\tlevel progress of loop-player is smaller than 0.9:", "\t\t\tincrease level progress of the loop-player by 0.1", "\t\telse:", "\t\t\tset level progress of the loop-player to 0.99", "on xp spawn:", "\tcancel event"})
@Since(value="2.0")
@Events(value={"level change"})
public class ExprLevelProgress
extends SimplePropertyExpression<Player, Float> {
    static {
        ExprLevelProgress.register(ExprLevelProgress.class, Float.class, "level progress", "players");
    }

    @Override
    public Float convert(Player p) {
        return Float.valueOf(p.getExp());
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.REMOVE_ALL) {
            return null;
        }
        return new Class[]{Number.class};
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        assert (mode != Changer.ChangeMode.REMOVE_ALL);
        float d = delta == null ? 0.0f : ((Number)delta[0]).floatValue();
        Player[] playerArray = (Player[])this.getExpr().getArray(e);
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            float c;
            Player p = playerArray[n2];
            switch (mode) {
                case SET: {
                    c = d;
                    break;
                }
                case ADD: {
                    c = p.getExp() + d;
                    break;
                }
                case REMOVE: {
                    c = p.getExp() - d;
                    break;
                }
                case DELETE: 
                case RESET: {
                    c = 0.0f;
                    break;
                }
                default: {
                    assert (false);
                    return;
                }
            }
            p.setLevel(Math.max(0, p.getLevel() + (int)Math.floor(c)));
            p.setExp(Math2.mod(c, 1.0f));
            ++n2;
        }
    }

    @Override
    public Class<? extends Float> getReturnType() {
        return Float.class;
    }

    @Override
    protected String getPropertyName() {
        return "level progress";
    }
}

