/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Item Amount")
@Description(value={"The amount of an <a href='classes.html#itemstack'>item stack</a>."})
@Examples(value={"send \"You have got %item amount of player's tool% %player's tool% in your hand !\" to player"})
@Since(value="2.2-dev24")
public class ExprItemAmount
extends SimplePropertyExpression<ItemStack, Number> {
    static {
        ExprItemAmount.register(ExprItemAmount.class, Number.class, "item[[ ]stack] (amount|size|number)", "itemstacks");
    }

    @Override
    public Class<Number> getReturnType() {
        return Number.class;
    }

    @Override
    protected String getPropertyName() {
        return "item[[ ]stack] (amount|size|number)";
    }

    @Override
    public Number convert(ItemStack itemstack) {
        return itemstack.getAmount();
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return mode != Changer.ChangeMode.REMOVE_ALL ? CollectionUtils.array(Number.class) : null;
    }

    @Override
    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        int amount = delta != null ? ((Number)delta[0]).intValue() : 0;
        switch (mode) {
            case ADD: {
                ItemStack[] itemStackArray = (ItemStack[])this.getExpr().getArray(event);
                int n = itemStackArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ItemStack itemstack = itemStackArray[n2];
                    itemstack.setAmount(itemstack.getAmount() + amount);
                    ++n2;
                }
                break;
            }
            case SET: {
                ItemStack[] itemStackArray = (ItemStack[])this.getExpr().getArray(event);
                int n = itemStackArray.length;
                int n3 = 0;
                while (n3 < n) {
                    ItemStack itemstack = itemStackArray[n3];
                    itemstack.setAmount(amount);
                    ++n3;
                }
                break;
            }
            case REMOVE: {
                ItemStack[] itemStackArray = (ItemStack[])this.getExpr().getArray(event);
                int n = itemStackArray.length;
                int n4 = 0;
                while (n4 < n) {
                    ItemStack itemstack = itemStackArray[n4];
                    itemstack.setAmount(itemstack.getAmount() - amount);
                    ++n4;
                }
                break;
            }
            case REMOVE_ALL: 
            case DELETE: 
            case RESET: {
                ItemStack[] itemStackArray = (ItemStack[])this.getExpr().getArray(event);
                int n = itemStackArray.length;
                int n5 = 0;
                while (n5 < n) {
                    ItemStack itemstack = itemStackArray[n5];
                    itemstack.setAmount(1);
                    ++n5;
                }
                break;
            }
        }
    }
}

