/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.LanguageChangeListener;
import ch.njol.util.StringUtils;
import java.util.HashMap;
import org.eclipse.jdt.annotation.Nullable;

public final class EnumUtils<E extends Enum<E>> {
    private final Class<E> c;
    private final String languageNode;
    private String[] names;
    private final HashMap<String, E> parseMap = new HashMap();

    public EnumUtils(Class<E> c, String languageNode) {
        assert (c != null && c.isEnum()) : c;
        assert (languageNode != null && !languageNode.isEmpty() && !languageNode.endsWith(".")) : languageNode;
        this.c = c;
        this.languageNode = languageNode;
        this.names = new String[((Enum[])c.getEnumConstants()).length];
        Language.addListener(new LanguageChangeListener(){

            @Override
            public void onLanguageChange() {
                EnumUtils.this.validate(true);
            }
        });
    }

    final void validate(boolean force) {
        boolean update = force;
        int newL = ((Enum[])this.c.getEnumConstants()).length;
        if (newL > this.names.length) {
            this.names = new String[newL];
            update = true;
        }
        if (update) {
            this.parseMap.clear();
            Enum[] enumArray = (Enum[])this.c.getEnumConstants();
            int n = enumArray.length;
            int n2 = 0;
            while (n2 < n) {
                Enum e = enumArray[n2];
                String[] ls = Language.getList(String.valueOf(this.languageNode) + "." + e.name());
                this.names[e.ordinal()] = ls[0];
                String[] stringArray = ls;
                int n3 = ls.length;
                int n4 = 0;
                while (n4 < n3) {
                    String l = stringArray[n4];
                    this.parseMap.put(l.toLowerCase(), e);
                    ++n4;
                }
                ++n2;
            }
        }
    }

    @Nullable
    public final E parse(String s) {
        this.validate(false);
        return (E)((Enum)this.parseMap.get(s.toLowerCase()));
    }

    public final String toString(E e, int flags) {
        this.validate(false);
        return this.names[((Enum)e).ordinal()];
    }

    public final String getAllNames() {
        this.validate(false);
        return StringUtils.join(this.names, ", ");
    }
}

