/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.hooks.permission.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.hooks.VaultHook;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import java.util.Collections;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Group")
@Description(value={"The primary group or all groups of a player. This expression requires Vault and a compatible permissions plugin to be installed."})
@Examples(value={"on join:", "broadcast \"%group of player%\" # this is the player's primary group", "broadcast \"%groups of player%\" # this is all of the player's groups"})
@Since(value="2.2-dev35")
public class ExprGroup
extends SimpleExpression<String> {
    private boolean primary;
    @Nullable
    private Expression<OfflinePlayer> players;

    static {
        PropertyExpression.register(ExprGroup.class, String.class, "group[(1\u00a6s)]", "offlineplayers");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!VaultHook.permission.hasGroupSupport()) {
            Skript.error("The permissions plugin you are using does not support groups.");
            return false;
        }
        this.players = exprs[0];
        this.primary = parseResult.mark == 0;
        return true;
    }

    protected String[] get(Event e) {
        ArrayList<String> groups = new ArrayList<String>();
        OfflinePlayer[] offlinePlayerArray = this.players.getArray(e);
        int n = offlinePlayerArray.length;
        int n2 = 0;
        while (n2 < n) {
            OfflinePlayer player = offlinePlayerArray[n2];
            if (this.primary) {
                groups.add(VaultHook.permission.getPrimaryGroup(null, player));
            } else {
                Collections.addAll(groups, VaultHook.permission.getPlayerGroups(null, player));
            }
            ++n2;
        }
        return groups.toArray(new String[0]);
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
            return new Class[]{String[].class};
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Permission api = VaultHook.permission;
        OfflinePlayer[] offlinePlayerArray = this.players.getArray(e);
        int n = offlinePlayerArray.length;
        int n2 = 0;
        while (n2 < n) {
            OfflinePlayer player = offlinePlayerArray[n2];
            switch (mode) {
                case ADD: {
                    Object o;
                    Object[] objectArray = delta;
                    int n3 = delta.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        o = objectArray[n4];
                        api.playerAddGroup(null, player, (String)o);
                        ++n4;
                    }
                    break;
                }
                case REMOVE: {
                    Object o;
                    Object[] objectArray = delta;
                    int n3 = delta.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        o = objectArray[n4];
                        api.playerRemoveGroup(null, player, (String)o);
                        ++n4;
                    }
                    break;
                }
                case SET: 
                case DELETE: 
                case RESET: {
                    Object o;
                    Object[] objectArray = api.getPlayerGroups(null, player);
                    int n3 = objectArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object group = objectArray[n4];
                        api.playerRemoveGroup(null, player, (String)group);
                        ++n4;
                    }
                    if (mode != Changer.ChangeMode.SET) break;
                    objectArray = delta;
                    n3 = delta.length;
                    n4 = 0;
                    while (n4 < n3) {
                        o = objectArray[n4];
                        api.playerAddGroup(null, player, (String)o);
                        ++n4;
                    }
                    break;
                }
            }
            ++n2;
        }
    }

    @Override
    public boolean isSingle() {
        return this.players.isSingle() && this.primary;
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "group" + (this.primary ? "" : "s") + " of " + this.players.toString(e, debug);
    }
}

