/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.hooks.chat.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.hooks.VaultHook;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Prefix/Suffix")
@Description(value={"The prefix or suffix as defined in the server's chat plugin."})
@Examples(value={"on chat:", "\tcancel event", "\tbroadcast \"%player's prefix%%player's display name%%player's suffix%: %message%\" to the player's world", "set the player's prefix to \"[<red>Admin<reset>] \""})
@Since(value="2.0")
public class ExprPrefixSuffix
extends SimplePropertyExpression<Player, String> {
    private boolean prefix;

    static {
        ExprPrefixSuffix.register(ExprPrefixSuffix.class, String.class, "[chat] (1\u00a6prefix|2\u00a6suffix)", "players");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.prefix = parseResult.mark == 1;
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Override
    public String convert(Player p) {
        return Utils.replaceChatStyles(this.prefix ? VaultHook.chat.getPlayerPrefix(p) : VaultHook.chat.getPlayerSuffix(p));
    }

    @Override
    protected String getPropertyName() {
        return this.prefix ? "prefix" : "suffix";
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return new Class[]{String.class};
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        assert (mode == Changer.ChangeMode.SET);
        assert (delta != null);
        Player[] playerArray = (Player[])this.getExpr().getArray(e);
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player p = playerArray[n2];
            if (this.prefix) {
                VaultHook.chat.setPlayerPrefix(p, (String)delta[0]);
            } else {
                VaultHook.chat.setPlayerSuffix(p, (String)delta[0]);
            }
            ++n2;
        }
    }
}

