/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.util.ConvertedExpression;
import ch.njol.skript.registrations.Converters;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Type of")
@Description(value={"The type of a block/item or entity. The type of an item is only it's id and data value, i.e. it ignores the amount, enchantments etc., and the type of an entity is e.g. 'wolf' or 'player'."})
@Examples(value={"on rightclick on an entity:", "\tmessage \"This is a %type of clicked entity%!\""})
@Since(value="1.4")
public class ExprTypeOf
extends SimplePropertyExpression<Object, Object> {
    static {
        ExprTypeOf.register(ExprTypeOf.class, Object.class, "type", "entitydatas/itemstacks/inventories");
    }

    @Override
    protected String getPropertyName() {
        return "type";
    }

    @Override
    @Nullable
    public Object convert(Object o) {
        if (o instanceof EntityData) {
            return ((EntityData)o).getSuperType();
        }
        if (o instanceof ItemStack) {
            return new ItemStack(((ItemStack)o).getType(), 1, ((ItemStack)o).getDurability());
        }
        if (o instanceof Inventory) {
            return ((Inventory)o).getType();
        }
        assert (false);
        return null;
    }

    @Override
    public Class<? extends Object> getReturnType() {
        return EntityData.class.isAssignableFrom(this.getExpr().getReturnType()) ? EntityData.class : (ItemStack.class.isAssignableFrom(this.getExpr().getReturnType()) ? ItemStack.class : Object.class);
    }

    @Override
    @Nullable
    protected <R> ConvertedExpression<Object, ? extends R> getConvertedExpr(Class<R> ... to) {
        if (!Converters.converterExists(EntityData.class, to) && !Converters.converterExists(ItemStack.class, to)) {
            return null;
        }
        return super.getConvertedExpr(to);
    }
}

