/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Getter;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Saturation")
@Description(value={"The saturation of a player. If used in a player event, it can be omitted and will default to event-player."})
@Examples(value={"set saturation of player to 20"})
@Since(value="2.2-Fixes-v10, 2.2-dev35 (fully modifiable)")
public class ExprSaturation
extends PropertyExpression<Player, Number> {
    static {
        Skript.registerExpression(ExprSaturation.class, Number.class, ExpressionType.PROPERTY, "[the] saturation [of %players%]", "%players%'[s] saturation");
    }

    @Override
    public Class<Number> getReturnType() {
        return Number.class;
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        return true;
    }

    protected Number[] get(Event e, Player[] source) {
        return this.get(source, new Getter<Float, Player>(){

            @Override
            public Float get(Player player) {
                return Float.valueOf(player.getSaturation());
            }
        });
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return mode != Changer.ChangeMode.REMOVE_ALL ? CollectionUtils.array(Number.class) : null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        float value = ((Number)delta[0]).floatValue();
        switch (mode) {
            case ADD: {
                Player[] playerArray = (Player[])this.getExpr().getArray(e);
                int n = playerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Player player = playerArray[n2];
                    player.setSaturation(player.getSaturation() + value);
                    ++n2;
                }
                break;
            }
            case REMOVE: {
                Player[] playerArray = (Player[])this.getExpr().getArray(e);
                int n = playerArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Player player = playerArray[n3];
                    player.setSaturation(player.getSaturation() - value);
                    ++n3;
                }
                break;
            }
            case SET: {
                Player[] playerArray = (Player[])this.getExpr().getArray(e);
                int n = playerArray.length;
                int n4 = 0;
                while (n4 < n) {
                    Player player = playerArray[n4];
                    player.setSaturation(value);
                    ++n4;
                }
                break;
            }
            case REMOVE_ALL: 
            case DELETE: 
            case RESET: {
                Player[] playerArray = (Player[])this.getExpr().getArray(e);
                int n = playerArray.length;
                int n5 = 0;
                while (n5 < n) {
                    Player player = playerArray[n5];
                    player.setSaturation(0.0f);
                    ++n5;
                }
                break;
            }
        }
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        return "saturation" + (this.getExpr().isDefault() ? "" : " of " + this.getExpr().toString(event, debug));
    }
}

