/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Getter;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Opened Inventory")
@Description(value={"Return the currently opened inventory of a player.", "If no inventory is open, it returns the own player's crafting inventory."})
@Examples(value={"set slot 1 of player's current inventory to diamond sword"})
@Since(value="2.2-dev24, 2.2-dev35 (Just 'current inventory' works in player events)")
public class ExprOpenedInventory
extends PropertyExpression<Player, Inventory> {
    static {
        Skript.registerExpression(ExprOpenedInventory.class, Inventory.class, ExpressionType.PROPERTY, "[the] (current|open|top) inventory [of %players%]", "%players%'[s] (current|open|top) inventory");
    }

    @Override
    public Class<? extends Inventory> getReturnType() {
        return Inventory.class;
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.setExpr(exprs[0]);
        return true;
    }

    protected Inventory[] get(Event event, Player[] source) {
        return this.get(source, new Getter<Inventory, Player>(){

            @Override
            public Inventory get(Player player) {
                return player.getOpenInventory() != null ? player.getOpenInventory().getTopInventory() : null;
            }
        });
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        return "current inventory" + (this.getExpr().isDefault() ? "" : " of " + this.getExpr().toString(event, debug));
    }
}

