/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Vectors - Create location from vector")
@Description(value={"Creates a location from a vector in a world"})
@Examples(value={"set {_loc} to {_v} to location in world \"world\"", "set {_loc} to {_v} to location in world \"world\" with yaw 45 and pitch 90", "set {_loc} to location of {_v} in \"world\" with yaw 45 and pitch 90"})
@Since(value="2.2-dev28")
public class ExprLocationFromVector
extends SimpleExpression<Location> {
    private Expression<Vector> vector;
    private Expression<World> world;
    private Expression<Number> yaw;
    private Expression<Number> pitch;
    private boolean yawpitch;

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    @Override
    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        if (expressions.length > 3) {
            this.yawpitch = true;
        }
        this.vector = expressions[0];
        this.world = expressions[1];
        if (this.yawpitch) {
            this.yaw = expressions[2];
            this.pitch = expressions[3];
        }
        return true;
    }

    protected Location[] get(Event event) {
        Number p;
        Vector v = this.vector.getSingle(event);
        World w = this.world.getSingle(event);
        Number y = this.yaw != null ? (Number)this.yaw.getSingle(event) : (Number)null;
        Number number = p = this.pitch != null ? (Number)this.pitch.getSingle(event) : (Number)null;
        if (v == null || w == null) {
            return null;
        }
        if (y == null || p == null) {
            return new Location[]{v.toLocation(w)};
        }
        return new Location[]{v.toLocation(w, y.floatValue(), p.floatValue())};
    }

    @Override
    public String toString(@Nullable Event event, boolean b) {
        if (this.yawpitch) {
            return "location from " + this.vector.toString() + " with yaw " + this.yaw.toString() + " and pitch " + this.pitch.toString();
        }
        return "location from " + this.vector.toString();
    }
}

