/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Events;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Getter;
import ch.njol.skript.util.slot.InventorySlot;
import ch.njol.skript.util.slot.Slot;
import ch.njol.util.Kleenean;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Furnace;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.inventory.FurnaceInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Furnace Slot")
@Description(value={"A slot of a furnace, i.e. either the ore, fuel or result slot.", "Remember to use '<a href='#ExprBlock'>block</a>' and not 'furnace', as 'furnace' is not an existing expression."})
@Examples(value={"set the fuel slot of the clicked block to a lava bucket", "set the block's ore slot to 64 iron ore", "give the result of the block to the player", "clear the result slot of the block"})
@Since(value="1.0")
@Events(value={"smelt", "fuel burn"})
public class ExprFurnaceSlot
extends PropertyExpression<Block, Slot> {
    private static final int ORE = 0;
    private static final int FUEL = 1;
    private static final int RESULT = 2;
    private static final String[] slotNames = new String[]{"ore", "fuel", "result"};
    int slot;

    static {
        ExprFurnaceSlot.register(ExprFurnaceSlot.class, Slot.class, "(0\u00a6ore|1\u00a6fuel|2\u00a6result)[s] [slot[s]]", "blocks");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.setExpr(exprs[0]);
        this.slot = parser.mark;
        return true;
    }

    protected Slot[] get(final Event e, Block[] source) {
        return this.get(source, new Getter<Slot, Block>(){

            @Override
            @Nullable
            public Slot get(Block b) {
                if (b.getType() != Material.FURNACE && b.getType() != Material.BURNING_FURNACE) {
                    return null;
                }
                if (ExprFurnaceSlot.this.getTime() >= 0 && (e instanceof FurnaceSmeltEvent && b.equals(((FurnaceSmeltEvent)e).getBlock()) || e instanceof FurnaceBurnEvent && b.equals(((FurnaceBurnEvent)e).getBlock())) && !Delay.isDelayed(e)) {
                    return new FurnaceEventSlot(e, ((Furnace)b.getState()).getInventory());
                }
                return new InventorySlot((Inventory)((Furnace)b.getState()).getInventory(), ExprFurnaceSlot.this.slot);
            }
        });
    }

    @Override
    public Class<Slot> getReturnType() {
        return Slot.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        if (e == null) {
            return "the " + (this.getTime() == -1 ? "past " : (this.getTime() == 1 ? "future " : "")) + slotNames[this.slot] + " slot of " + this.getExpr().toString(e, debug);
        }
        return Classes.getDebugMessage(this.getSingle(e));
    }

    @Override
    public boolean setTime(int time) {
        return super.setTime(time, this.getExpr(), FurnaceSmeltEvent.class, FurnaceBurnEvent.class);
    }

    private final class FurnaceEventSlot
    extends InventorySlot {
        private final Event e;

        public FurnaceEventSlot(Event e, FurnaceInventory invi) {
            super((Inventory)invi, ExprFurnaceSlot.this.slot);
            this.e = e;
        }

        @Override
        @Nullable
        public ItemStack getItem() {
            if (this.e instanceof FurnaceSmeltEvent) {
                if (ExprFurnaceSlot.this.slot == 2) {
                    if (ExprFurnaceSlot.this.getTime() >= 0) {
                        return ((FurnaceSmeltEvent)this.e).getResult().clone();
                    }
                    return super.getItem();
                }
                if (ExprFurnaceSlot.this.slot == 0) {
                    if (ExprFurnaceSlot.this.getTime() <= 0) {
                        return super.getItem();
                    }
                    ItemStack i = super.getItem();
                    if (i == null) {
                        return null;
                    }
                    i.setAmount(i.getAmount() - 1);
                    return i.getAmount() == 0 ? new ItemStack(Material.AIR, 1) : i;
                }
                return super.getItem();
            }
            if (ExprFurnaceSlot.this.slot == 1) {
                if (ExprFurnaceSlot.this.getTime() <= 0) {
                    return super.getItem();
                }
                ItemStack i = super.getItem();
                if (i == null) {
                    return null;
                }
                i.setAmount(i.getAmount() - 1);
                return i.getAmount() == 0 ? new ItemStack(Material.AIR, 1) : i;
            }
            return super.getItem();
        }

        @Override
        public void setItem(final @Nullable ItemStack item) {
            if (this.e instanceof FurnaceSmeltEvent) {
                if (ExprFurnaceSlot.this.slot == 2 && ExprFurnaceSlot.this.getTime() >= 0) {
                    if (item == null || item.getType() == Material.AIR) {
                        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.getInstance(), new Runnable(){

                            @Override
                            public void run() {
                                FurnaceEventSlot.super.setItem(null);
                            }
                        });
                    } else {
                        ((FurnaceSmeltEvent)this.e).setResult(item);
                    }
                } else if (ExprFurnaceSlot.this.slot == 0 && ExprFurnaceSlot.this.getTime() >= 0) {
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.getInstance(), new Runnable(){

                        @Override
                        public void run() {
                            FurnaceEventSlot.super.setItem(item);
                        }
                    });
                } else {
                    super.setItem(item);
                }
            } else if (ExprFurnaceSlot.this.slot == 1 && ExprFurnaceSlot.this.getTime() >= 0) {
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.getInstance(), new Runnable(){

                    @Override
                    public void run() {
                        FurnaceEventSlot.super.setItem(item);
                    }
                });
            } else {
                super.setItem(item);
            }
        }
    }
}

