/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Exhaustion")
@Description(value={"The exhaustion of a player. This is mainly used to determine the rate of hunger depletion."})
@Examples(value={"set exhaustion of all players to 1"})
@Since(value="2.2-dev35")
public class ExprExhaustion
extends SimplePropertyExpression<Player, Number> {
    static {
        ExprExhaustion.register(ExprExhaustion.class, Number.class, "exhaustion", "players");
    }

    @Override
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @Override
    protected String getPropertyName() {
        return "exhaustion";
    }

    @Override
    @Nullable
    public Number convert(Player player) {
        return Float.valueOf(player.getExhaustion());
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return CollectionUtils.array(Number.class);
    }

    @Override
    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        float exhaustion = ((Number)delta[0]).floatValue();
        switch (mode) {
            case ADD: {
                Player[] playerArray = (Player[])this.getExpr().getArray(event);
                int n = playerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Player player = playerArray[n2];
                    player.setExhaustion(player.getExhaustion() + exhaustion);
                    ++n2;
                }
                break;
            }
            case REMOVE: {
                Player[] playerArray = (Player[])this.getExpr().getArray(event);
                int n = playerArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Player player = playerArray[n3];
                    player.setExhaustion(player.getExhaustion() - exhaustion);
                    ++n3;
                }
                break;
            }
            case SET: {
                Player[] playerArray = (Player[])this.getExpr().getArray(event);
                int n = playerArray.length;
                int n4 = 0;
                while (n4 < n) {
                    Player player = playerArray[n4];
                    player.setExhaustion(((Number)delta[0]).floatValue());
                    ++n4;
                }
                break;
            }
            case REMOVE_ALL: 
            case DELETE: 
            case RESET: {
                Player[] playerArray = (Player[])this.getExpr().getArray(event);
                int n = playerArray.length;
                int n5 = 0;
                while (n5 < n) {
                    Player player = playerArray[n5];
                    player.setExhaustion(0.0f);
                    ++n5;
                }
                break;
            }
        }
    }
}

